/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.bumblezone.fluids;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.IFluidState;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.telepathicgrunt.bumblezone.blocks.BzBlocks;

public abstract class SugarWaterFluid
extends ForgeFlowingFluid {
    protected SugarWaterFluid(ForgeFlowingFluid.Properties properties) {
        super(properties);
    }

    public void func_207186_b(World world, BlockPos position, IFluidState state, Random random) {
        if (random.nextBoolean() || !world.isAreaLoaded(position, 1)) {
            return;
        }
        BlockPos.Mutable blockPos = new BlockPos.Mutable(position.func_177984_a());
        blockPos.func_189536_c(Direction.func_176731_b((int)random.nextInt(4)));
        BlockState blockstate = world.func_180495_p((BlockPos)blockPos);
        if (blockstate.func_177230_c() == Blocks.field_196608_cF) {
            int height;
            blockstate = world.func_180495_p((BlockPos)blockPos.func_189536_c(Direction.UP));
            for (height = 1; blockstate.func_177230_c() == Blocks.field_196608_cF && height < 5; ++height) {
                blockstate = world.func_180495_p((BlockPos)blockPos.func_189536_c(Direction.UP));
            }
            if (height < 5 && blockstate.func_185904_a() == Material.field_151579_a) {
                world.func_180501_a((BlockPos)blockPos, Blocks.field_196608_cF.func_176223_P(), 3);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_204522_a(World worldIn, BlockPos pos, IFluidState state, Random random) {
        if (!state.func_206889_d() && !((Boolean)state.func_177229_b((IProperty)field_207209_a)).booleanValue()) {
            if (random.nextInt(64) == 0) {
                worldIn.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187917_gq, SoundCategory.BLOCKS, random.nextFloat() * 0.25f + 0.75f, random.nextFloat() + 0.5f, false);
            }
        } else if (random.nextInt(10) == 0) {
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197605_P, (double)pos.func_177958_n() + (double)random.nextFloat(), (double)pos.func_177956_o() + (double)random.nextFloat(), (double)pos.func_177952_p() + (double)random.nextFloat(), 0.0, 0.0, 0.0);
        }
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public IParticleData func_204521_c() {
        return ParticleTypes.field_197618_k;
    }

    protected boolean func_207196_h() {
        return true;
    }

    public int func_205569_a(IWorldReader p_205569_1_) {
        return 5;
    }

    public boolean func_207187_a(Fluid fluidIn) {
        return fluidIn == BzBlocks.SUGAR_WATER_FLUID.get() || fluidIn == BzBlocks.SUGAR_WATER_FLUID_FLOWING.get();
    }

    public static class Source
    extends SugarWaterFluid {
        public Source(ForgeFlowingFluid.Properties properties) {
            super(properties);
        }

        public int func_207192_d(IFluidState state) {
            return 8;
        }

        public boolean func_207193_c(IFluidState state) {
            return true;
        }
    }

    public static class Flowing
    extends SugarWaterFluid {
        public Flowing(ForgeFlowingFluid.Properties properties) {
            super(properties);
            this.func_207183_f((IFluidState)((IFluidState)this.func_207182_e().func_177621_b()).func_206870_a((IProperty)field_207210_b, (Comparable)Integer.valueOf(7)));
        }

        protected void func_207184_a(StateContainer.Builder<Fluid, IFluidState> builder) {
            super.func_207184_a(builder);
            builder.func_206894_a(new IProperty[]{field_207210_b});
        }

        public int func_207192_d(IFluidState state) {
            return (Integer)state.func_177229_b((IProperty)field_207210_b);
        }

        public boolean func_207193_c(IFluidState state) {
            return false;
        }
    }
}

