/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.bumblezone.entities;

import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.block.BeehiveBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.item.EnderPearlEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.server.TicketType;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.telepathicgrunt.bumblezone.Bumblezone;
import net.telepathicgrunt.bumblezone.capabilities.IPlayerPosAndDim;
import net.telepathicgrunt.bumblezone.capabilities.PlayerPositionAndDimension;
import net.telepathicgrunt.bumblezone.dimension.BzDimensionRegistration;
import net.telepathicgrunt.bumblezone.modcompatibility.ModChecking;
import net.telepathicgrunt.bumblezone.modcompatibility.ProductiveBeesRedirection;
import net.telepathicgrunt.bumblezone.utils.BzPlacingUtils;
import org.apache.logging.log4j.Level;

@Mod.EventBusSubscriber(modid="the_bumblezone", bus=Mod.EventBusSubscriber.Bus.MOD)
public class PlayerTeleportationBehavior {
    @CapabilityInject(value=IPlayerPosAndDim.class)
    public static Capability<IPlayerPosAndDim> PAST_POS_AND_DIM = null;

    private static void reAddPotionEffect(PlayerEntity playerEntity) {
        ArrayList effectInstanceList = new ArrayList(playerEntity.func_70651_bq());
        for (int i = effectInstanceList.size() - 1; i >= 0; --i) {
            EffectInstance effectInstance = (EffectInstance)effectInstanceList.get(i);
            if (effectInstance == null) continue;
            playerEntity.func_184596_c(effectInstance.func_188419_a());
            playerEntity.func_195064_c(new EffectInstance(effectInstance.func_188419_a(), effectInstance.func_76459_b(), effectInstance.func_76458_c(), effectInstance.func_82720_e(), effectInstance.func_188418_e(), effectInstance.func_205348_f()));
        }
    }

    private static void teleportByOutOfBounds(PlayerEntity playerEntity, PlayerPositionAndDimension cap, boolean checkingUpward) {
        MinecraftServer minecraftServer = playerEntity.func_184102_h();
        ServerWorld bumblezoneWorld = minecraftServer.func_71218_a(BzDimensionRegistration.bumblezone());
        ServerWorld destinationWorld = cap.getNonBZDim() == BzDimensionRegistration.bumblezone() && Bumblezone.BzConfig.forceExitToOverworld.get() != false ? minecraftServer.func_71218_a(DimensionType.field_223227_a_) : minecraftServer.func_71218_a(cap.getNonBZDim());
        BlockPos blockpos = new BlockPos((double)playerEntity.func_180425_c().func_177958_n() / destinationWorld.func_201675_m().getMovementFactor() * bumblezoneWorld.func_201675_m().getMovementFactor(), (double)playerEntity.func_180425_c().func_177956_o(), (double)playerEntity.func_180425_c().func_177952_p() / destinationWorld.func_201675_m().getMovementFactor() * bumblezoneWorld.func_201675_m().getMovementFactor());
        BlockPos validBlockPos = PlayerTeleportationBehavior.validPlayerSpawnLocationByBeehive((World)destinationWorld, blockpos, 48, checkingUpward);
        ChunkPos chunkpos = new ChunkPos(validBlockPos);
        destinationWorld.func_72863_F().func_217228_a(TicketType.field_223185_g, chunkpos, 1, (Object)playerEntity.func_145782_y());
        ((ServerPlayerEntity)playerEntity).func_200619_a(destinationWorld, (double)validBlockPos.func_177958_n() + 0.5, (double)(validBlockPos.func_177956_o() + 1), (double)validBlockPos.func_177952_p() + 0.5, playerEntity.field_70177_z, playerEntity.field_70125_A);
        cap.setTeleporting(false);
    }

    private static void teleportByPearl(PlayerEntity playerEntity, PlayerPositionAndDimension cap) {
        BlockPos blockpos;
        MinecraftServer minecraftServer = playerEntity.func_184102_h();
        ServerWorld originalWorld = minecraftServer.func_71218_a(playerEntity.field_71093_bK);
        ServerWorld bumblezoneWorld = minecraftServer.func_71218_a(BzDimensionRegistration.bumblezone());
        Object validBlockPos = PlayerTeleportationBehavior.validPlayerSpawnLocation((World)bumblezoneWorld, blockpos = new BlockPos((double)playerEntity.func_180425_c().func_177958_n() / bumblezoneWorld.func_201675_m().getMovementFactor() * originalWorld.func_201675_m().getMovementFactor(), (double)playerEntity.func_180425_c().func_177956_o(), (double)playerEntity.func_180425_c().func_177952_p() / bumblezoneWorld.func_201675_m().getMovementFactor() * originalWorld.func_201675_m().getMovementFactor()), 10);
        if (validBlockPos == null) {
            validBlockPos = new BlockPos(blockpos.func_177958_n(), BzPlacingUtils.topOfSurfaceBelowHeightThroughWater((IWorld)bumblezoneWorld, blockpos.func_177956_o() + 50, 0, blockpos) + 1, blockpos.func_177952_p());
            if (validBlockPos.func_177956_o() == 0) {
                validBlockPos = null;
            } else if (bumblezoneWorld.func_180495_p(validBlockPos).func_185904_a() == Material.field_151586_h && bumblezoneWorld.func_180495_p(validBlockPos.func_177984_a()).func_185904_a() == Material.field_151586_h) {
                BlockPos.Mutable mutable = new BlockPos.Mutable(validBlockPos);
                while (mutable.func_177956_o() < 255 && !bumblezoneWorld.func_175623_d((BlockPos)mutable) || bumblezoneWorld.func_180495_p((BlockPos)mutable).func_185904_a() == Material.field_151586_h) {
                    mutable.func_189536_c(Direction.UP);
                }
                validBlockPos = bumblezoneWorld.func_180495_p((BlockPos)mutable).func_185904_a() != Material.field_151579_a ? null : mutable;
            } else if (!bumblezoneWorld.func_175623_d(validBlockPos) && bumblezoneWorld.func_180495_p(validBlockPos).func_185904_a() != Material.field_151586_h && bumblezoneWorld.func_180495_p(validBlockPos.func_177984_a()).func_185904_a() != Material.field_151579_a) {
                validBlockPos = null;
            }
            if (validBlockPos == null) {
                bumblezoneWorld.func_175656_a(blockpos, Blocks.field_150350_a.func_176223_P());
                bumblezoneWorld.func_175656_a(blockpos.func_177984_a(), Blocks.field_150350_a.func_176223_P());
                bumblezoneWorld.func_175656_a(blockpos.func_177977_b(), Blocks.field_226908_md_.func_176223_P());
                bumblezoneWorld.func_175656_a(blockpos.func_177984_a().func_177984_a(), Blocks.field_226908_md_.func_176223_P());
                bumblezoneWorld.func_175656_a(blockpos.func_177978_c(), Blocks.field_226908_md_.func_176223_P());
                bumblezoneWorld.func_175656_a(blockpos.func_177976_e(), Blocks.field_226908_md_.func_176223_P());
                bumblezoneWorld.func_175656_a(blockpos.func_177974_f(), Blocks.field_226908_md_.func_176223_P());
                bumblezoneWorld.func_175656_a(blockpos.func_177968_d(), Blocks.field_226908_md_.func_176223_P());
                bumblezoneWorld.func_175656_a(blockpos.func_177978_c().func_177984_a(), Blocks.field_226908_md_.func_176223_P());
                bumblezoneWorld.func_175656_a(blockpos.func_177976_e().func_177984_a(), Blocks.field_226908_md_.func_176223_P());
                bumblezoneWorld.func_175656_a(blockpos.func_177974_f().func_177984_a(), Blocks.field_226908_md_.func_176223_P());
                bumblezoneWorld.func_175656_a(blockpos.func_177968_d().func_177984_a(), Blocks.field_226908_md_.func_176223_P());
                validBlockPos = blockpos;
            }
        }
        if (playerEntity.func_70608_bn()) {
            playerEntity.func_213366_dy();
        }
        ChunkPos chunkpos = new ChunkPos(validBlockPos);
        bumblezoneWorld.func_72863_F().func_217228_a(TicketType.field_223185_g, chunkpos, 1, (Object)playerEntity.func_145782_y());
        ((ServerPlayerEntity)playerEntity).func_200619_a(bumblezoneWorld, (double)validBlockPos.func_177958_n() + 0.5, (double)validBlockPos.func_177956_o(), (double)validBlockPos.func_177952_p() + 0.5, playerEntity.field_70177_z, playerEntity.field_70125_A);
        cap.setTeleporting(false);
    }

    private static BlockPos validPlayerSpawnLocationByBeehive(World world, BlockPos position, int maximumRange, boolean checkingUpward) {
        int maxHeight = 0;
        int halfRange = maximumRange / 2;
        BlockPos.Mutable mutableBlockPos = new BlockPos.Mutable();
        for (int x = -halfRange; x < halfRange; ++x) {
            for (int z = -halfRange; z < halfRange; ++z) {
                mutableBlockPos.func_181079_c(position.func_177958_n() + x, 0, position.func_177952_p() + z);
                if (!world.func_217354_b(mutableBlockPos.func_177958_n() >> 4, mutableBlockPos.func_177952_p() >> 4)) {
                    world.func_217349_x((BlockPos)mutableBlockPos);
                }
                maxHeight = Math.max(maxHeight, world.func_201676_a(Heightmap.Type.MOTION_BLOCKING, mutableBlockPos.func_177958_n(), mutableBlockPos.func_177952_p()));
            }
        }
        maxHeight = Math.min(maxHeight, world.func_72940_L() - 1);
        mutableBlockPos.func_181079_c(position.func_177958_n(), checkingUpward ? 0 : maxHeight, position.func_177952_p());
        while (mutableBlockPos.func_177956_o() >= 0 && mutableBlockPos.func_177956_o() <= maxHeight) {
            for (int range = 0; range < maximumRange; ++range) {
                int radius = range * range;
                int nextRadius = (range + 1) * (range + 1);
                for (int x = 0; x <= range * 2; ++x) {
                    int x2 = x > range ? -(x - range) : x;
                    for (int z = 0; z <= range * 2; ++z) {
                        BlockPos validSpot;
                        int z2;
                        int n = z2 = z > range ? -(z - range) : x;
                        if (x2 * x2 + z2 * z2 < radius || x2 * x2 + z2 * z2 >= nextRadius) continue;
                        mutableBlockPos.func_181079_c(position.func_177958_n() + x2, mutableBlockPos.func_177956_o(), position.func_177952_p() + z2);
                        if (!PlayerTeleportationBehavior.isValidBeeHive(world.func_180495_p((BlockPos)mutableBlockPos)) || (validSpot = PlayerTeleportationBehavior.validPlayerSpawnLocation(world, (BlockPos)mutableBlockPos, 4)) == null) continue;
                        return validSpot;
                    }
                }
            }
            if (checkingUpward) {
                mutableBlockPos.func_189536_c(Direction.UP);
                continue;
            }
            mutableBlockPos.func_189536_c(Direction.DOWN);
        }
        if (maxHeight + 1 < world.func_72940_L()) {
            ++maxHeight;
        }
        mutableBlockPos.func_181079_c(position.func_177958_n(), BzPlacingUtils.topOfSurfaceBelowHeight((IWorld)world, maxHeight, -1, position), position.func_177952_p());
        if (mutableBlockPos.func_177956_o() > 0) {
            world.func_175656_a((BlockPos)mutableBlockPos, Blocks.field_226905_ma_.func_176223_P());
            world.func_175656_a(mutableBlockPos.func_177984_a(), Blocks.field_150350_a.func_176223_P());
            return mutableBlockPos;
        }
        mutableBlockPos.func_181079_c(position.func_177958_n(), world.func_201675_m().getActualHeight() / 2, position.func_177952_p());
        world.func_175656_a((BlockPos)mutableBlockPos, Blocks.field_226905_ma_.func_176223_P());
        world.func_175656_a(mutableBlockPos.func_177984_a(), Blocks.field_150350_a.func_176223_P());
        return mutableBlockPos;
    }

    @Nullable
    private static BlockPos validPlayerSpawnLocation(World world, BlockPos position, int maximumRange) {
        int radius = 0;
        int outterRadius = 0;
        int distanceSq = 0;
        BlockPos.Mutable currentPos = new BlockPos.Mutable(position);
        for (int range = 0; range < maximumRange; ++range) {
            radius = range * range;
            outterRadius = (range + 1) * (range + 1);
            for (int y = 0; y <= range * 2; ++y) {
                int y2 = y > range ? -(y - range) : y;
                for (int x = 0; x <= range * 2; ++x) {
                    int x2 = x > range ? -(x - range) : x;
                    for (int z = 0; z <= range * 2; ++z) {
                        int z2 = z > range ? -(z - range) : z;
                        distanceSq = x2 * x2 + z2 * z2 + y2 * y2;
                        if (distanceSq < radius || distanceSq >= outterRadius) continue;
                        currentPos.func_189533_g((Vec3i)position.func_177982_a(x2, y2, z2));
                        if (!world.func_180495_p(currentPos.func_177977_b()).func_200132_m() || world.func_180495_p((BlockPos)currentPos).func_185904_a() != Material.field_151579_a || world.func_180495_p(currentPos.func_177984_a()).func_185904_a() != Material.field_151579_a) continue;
                        return currentPos;
                    }
                }
            }
        }
        return null;
    }

    private static boolean isValidBeeHive(BlockState block) {
        if (block.func_177230_c() instanceof BeehiveBlock && (Bumblezone.BzConfig.allowTeleportationWithModdedBeehives.get().booleanValue() || block.func_177230_c().getRegistryName().func_110624_b().equals("minecraft"))) {
            return true;
        }
        return ModChecking.productiveBeesPresent && Bumblezone.BzConfig.allowTeleportationWithModdedBeehives.get() != false && ProductiveBeesRedirection.PBIsAdvancedBeehiveAbstractBlock(block);
    }

    @Mod.EventBusSubscriber(modid="the_bumblezone")
    private static class ForgeEvents {
        private ForgeEvents() {
        }

        @SubscribeEvent
        public static void ProjectileImpactEvent(ProjectileImpactEvent.Throwable event) {
            if (!(event.getEntity() instanceof EnderPearlEntity)) {
                return;
            }
            EnderPearlEntity pearlEntity = (EnderPearlEntity)event.getEntity();
            World world = pearlEntity.field_70170_p;
            if (!world.field_72995_K && pearlEntity.func_85052_h() instanceof ServerPlayerEntity) {
                String requiredBlockString;
                ServerPlayerEntity playerEntity = (ServerPlayerEntity)pearlEntity.func_85052_h();
                Vec3d hitBlockPos = event.getRayTraceResult().func_216347_e();
                BlockPos hivePos = new BlockPos(0, 0, 0);
                boolean hitHive = false;
                for (double offset = -0.1; offset <= 0.1; offset += 0.1) {
                    BlockState block = world.func_180495_p(new BlockPos(hitBlockPos.func_72441_c(offset, 0.0, 0.0)));
                    if (PlayerTeleportationBehavior.isValidBeeHive(block)) {
                        hitHive = true;
                        hivePos = new BlockPos(hitBlockPos.func_72441_c(offset, 0.0, 0.0));
                        break;
                    }
                    block = world.func_180495_p(new BlockPos(hitBlockPos.func_72441_c(0.0, offset, 0.0)));
                    if (PlayerTeleportationBehavior.isValidBeeHive(block)) {
                        hitHive = true;
                        hivePos = new BlockPos(hitBlockPos.func_72441_c(0.0, offset, 0.0));
                        break;
                    }
                    block = world.func_180495_p(new BlockPos(hitBlockPos.func_72441_c(0.0, 0.0, offset)));
                    if (!PlayerTeleportationBehavior.isValidBeeHive(block)) continue;
                    hitHive = true;
                    hivePos = new BlockPos(hitBlockPos.func_72441_c(0.0, 0.0, offset));
                    break;
                }
                if (!(requiredBlockString = Bumblezone.BzConfig.requiredBlockUnderHive.get()).isEmpty() && ResourceLocation.func_217855_b((String)requiredBlockString)) {
                    ResourceLocation requiredBlockRL = new ResourceLocation(requiredBlockString);
                    if (ForgeRegistries.BLOCKS.containsKey(requiredBlockRL)) {
                        Block requiredBlock = (Block)ForgeRegistries.BLOCKS.getValue(requiredBlockRL);
                        if (requiredBlock != world.func_180495_p(hivePos.func_177977_b()).func_177230_c().getBlock() && Bumblezone.BzConfig.warnPlayersOfWrongBlockUnderHive.get().booleanValue()) {
                            String beeBlock = world.func_180495_p(hivePos).func_177230_c().func_200291_n().getString();
                            Bumblezone.LOGGER.log(Level.INFO, "Bumblezone: The block under the " + beeBlock + " is not the correct block to teleport to Bumblezone. The config enter says it needs " + requiredBlockString + " under " + beeBlock + ".");
                            StringTextComponent message = new StringTextComponent("\u00a7eBumblezone:\u00a7f The block under the \u00a76" + beeBlock + "\u00a7f is not the correct block to teleport to Bumblezone. The config enter says it needs \u00a76" + requiredBlockString + "\u00a7f under \u00a76" + beeBlock + "\u00a7f.");
                            playerEntity.func_145747_a((ITextComponent)message);
                            return;
                        }
                    } else {
                        Bumblezone.LOGGER.log(Level.INFO, "Bumblezone: The required block under beenest config is broken. Please specify a resourcelocation to a real block or leave it blank so that players can teleport to Bumblezone dimension. Currently, the broken config has this in it: " + requiredBlockString);
                        StringTextComponent message = new StringTextComponent("\u00a7eBumblezone:\u00a7f The required block under beenest config is broken. Please specify a resourcelocation to a real block or leave it blank so that players can teleport to Bumblezone dimension. Currently, the broken config has this in it: \u00a7c" + requiredBlockString);
                        playerEntity.func_145747_a((ITextComponent)message);
                        return;
                    }
                }
                if (hitHive && playerEntity.field_71093_bK != BzDimensionRegistration.bumblezone()) {
                    PlayerPositionAndDimension cap = (PlayerPositionAndDimension)playerEntity.getCapability(PAST_POS_AND_DIM).orElseThrow(RuntimeException::new);
                    DimensionType destination = BzDimensionRegistration.bumblezone();
                    cap.setDestDim(destination);
                    cap.setTeleporting(true);
                    event.setCanceled(true);
                    pearlEntity.func_70106_y();
                }
            }
        }

        @SubscribeEvent
        public static void playerTick(TickEvent.PlayerTickEvent event) {
            PlayerEntity playerEntity = event.player;
            if (playerEntity.field_70170_p instanceof ServerWorld) {
                PlayerPositionAndDimension cap = (PlayerPositionAndDimension)playerEntity.getCapability(PAST_POS_AND_DIM).orElseThrow(RuntimeException::new);
                if (cap.isTeleporting) {
                    PlayerTeleportationBehavior.teleportByPearl(playerEntity, cap);
                    PlayerTeleportationBehavior.reAddPotionEffect(playerEntity);
                } else if ((playerEntity.func_226278_cu_() < -1.0 || playerEntity.func_226278_cu_() > 255.0) && playerEntity.field_71093_bK == BzDimensionRegistration.bumblezone()) {
                    playerEntity.field_70143_R = 0.0f;
                    PlayerTeleportationBehavior.teleportByOutOfBounds(playerEntity, cap, playerEntity.func_226278_cu_() < -1.0);
                    PlayerTeleportationBehavior.reAddPotionEffect(playerEntity);
                }
            }
            if (playerEntity.func_226278_cu_() < -3.0 && playerEntity.field_71093_bK == BzDimensionRegistration.bumblezone()) {
                playerEntity.field_70143_R = 0.0f;
                playerEntity.func_70107_b(playerEntity.func_226277_ct_(), -3.0, playerEntity.func_226281_cx_());
            }
        }

        @SubscribeEvent
        public static void entityTravelToDimensionEvent(EntityTravelToDimensionEvent event) {
            if (event.getEntity() instanceof PlayerEntity) {
                PlayerEntity playerEntity = (PlayerEntity)event.getEntity();
                PlayerPositionAndDimension cap = (PlayerPositionAndDimension)playerEntity.getCapability(PAST_POS_AND_DIM).orElseThrow(RuntimeException::new);
                if (playerEntity.field_71093_bK != BzDimensionRegistration.bumblezone()) {
                    cap.setNonBZDim(playerEntity.field_71093_bK);
                }
            }
        }
    }
}

