/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.naturescompass.gui;

import com.chaosthedude.naturescompass.NaturesCompass;
import com.chaosthedude.naturescompass.gui.BiomeSearchEntry;
import com.chaosthedude.naturescompass.gui.BiomeSearchList;
import com.chaosthedude.naturescompass.gui.GuiTransparentButton;
import com.chaosthedude.naturescompass.gui.GuiTransparentTextField;
import com.chaosthedude.naturescompass.items.NaturesCompassItem;
import com.chaosthedude.naturescompass.network.CompassSearchPacket;
import com.chaosthedude.naturescompass.network.TeleportPacket;
import com.chaosthedude.naturescompass.sorting.ISortingCategory;
import com.chaosthedude.naturescompass.sorting.NameCategory;
import com.chaosthedude.naturescompass.util.BiomeUtils;
import com.chaosthedude.naturescompass.util.CompassState;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class NaturesCompassScreen
extends Screen {
    private World world;
    private PlayerEntity player;
    private List<Biome> allowedBiomes;
    private List<Biome> biomesMatchingSearch;
    private ItemStack stack;
    private NaturesCompassItem natureCompass;
    private Button startSearchButton;
    private Button teleportButton;
    private Button infoButton;
    private Button cancelButton;
    private Button sortByButton;
    private GuiTransparentTextField searchTextField;
    private BiomeSearchList selectionList;
    private ISortingCategory sortingCategory;

    public NaturesCompassScreen(World world, PlayerEntity player, ItemStack stack, NaturesCompassItem natureCompass, List<Biome> allowedBiomes) {
        super((ITextComponent)new StringTextComponent(I18n.func_135052_a((String)"string.naturescompass.selectBiome", (Object[])new Object[0])));
        this.world = world;
        this.player = player;
        this.stack = stack;
        this.natureCompass = natureCompass;
        this.allowedBiomes = allowedBiomes;
        this.sortingCategory = new NameCategory();
        this.biomesMatchingSearch = new ArrayList<Biome>(allowedBiomes);
    }

    public boolean mouseScrolled(double scroll1, double scroll2, double scroll3) {
        return this.selectionList.mouseScrolled(scroll1, scroll2, scroll3);
    }

    protected void init() {
        this.minecraft.field_195559_v.func_197967_a(true);
        this.setupButtons();
        this.setupTextFields();
        if (this.selectionList == null) {
            this.selectionList = new BiomeSearchList(this, this.minecraft, this.width + 110, this.height, 40, this.height, 45);
        }
        this.children.add(this.selectionList);
    }

    public void tick() {
        this.searchTextField.func_146178_a();
        this.teleportButton.active = this.natureCompass.getState(this.stack) == CompassState.FOUND;
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        this.selectionList.render(mouseX, mouseY, partialTicks);
        this.searchTextField.render(mouseX, mouseY, partialTicks);
        this.drawCenteredString(this.font, I18n.func_135052_a((String)"string.naturescompass.selectBiome", (Object[])new Object[0]), 65, 15, 0xFFFFFF);
        super.render(mouseX, mouseY, partialTicks);
    }

    public boolean keyPressed(int par1, int par2, int par3) {
        boolean ret = super.keyPressed(par1, par2, par3);
        if (this.searchTextField.isFocused()) {
            this.processSearchTerm();
            return true;
        }
        return ret;
    }

    public boolean charTyped(char typedChar, int keyCode) {
        boolean ret = super.charTyped(typedChar, keyCode);
        if (this.searchTextField.isFocused()) {
            this.processSearchTerm();
            return true;
        }
        return ret;
    }

    public void onClose() {
        super.onClose();
        this.minecraft.field_195559_v.func_197967_a(false);
    }

    public void selectBiome(BiomeSearchEntry entry) {
        boolean enable;
        this.startSearchButton.active = enable = entry != null;
        this.infoButton.active = enable;
    }

    public void searchForBiome(Biome biome) {
        NaturesCompass.network.sendToServer((Object)new CompassSearchPacket(BiomeUtils.getIDForBiome(biome), this.player.func_180425_c()));
        this.minecraft.func_147108_a(null);
    }

    public void teleport() {
        NaturesCompass.network.sendToServer((Object)new TeleportPacket());
        this.minecraft.func_147108_a(null);
    }

    public ISortingCategory getSortingCategory() {
        return this.sortingCategory;
    }

    public void processSearchTerm() {
        this.biomesMatchingSearch = new ArrayList<Biome>();
        for (Biome biome : this.allowedBiomes) {
            if (!BiomeUtils.getBiomeNameForDisplay(biome).toLowerCase().contains(this.searchTextField.func_146179_b().toLowerCase())) continue;
            this.biomesMatchingSearch.add(biome);
        }
        this.selectionList.refreshList();
    }

    public List<Biome> sortBiomes() {
        List<Biome> biomes = this.biomesMatchingSearch;
        Collections.sort(biomes, new NameCategory());
        Collections.sort(biomes, this.sortingCategory);
        return biomes;
    }

    private void setupButtons() {
        this.buttons.clear();
        this.cancelButton = (Button)this.addButton((Widget)new GuiTransparentButton(10, this.height - 30, 110, 20, I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0]), onPress -> this.minecraft.func_147108_a(null)));
        this.sortByButton = (Button)this.addButton((Widget)new GuiTransparentButton(10, 90, 110, 20, I18n.func_135052_a((String)"string.naturescompass.sortBy", (Object[])new Object[0]) + ": " + this.sortingCategory.getLocalizedName(), onPress -> {
            this.sortingCategory = this.sortingCategory.next();
            this.sortByButton.setMessage(I18n.func_135052_a((String)"string.naturescompass.sortBy", (Object[])new Object[0]) + ": " + this.sortingCategory.getLocalizedName());
            this.selectionList.refreshList();
        }));
        this.infoButton = (Button)this.addButton((Widget)new GuiTransparentButton(10, 65, 110, 20, I18n.func_135052_a((String)"string.naturescompass.info", (Object[])new Object[0]), onPress -> {
            if (this.selectionList.hasSelection()) {
                ((BiomeSearchEntry)this.selectionList.getSelected()).viewInfo();
            }
        }));
        this.startSearchButton = (Button)this.addButton((Widget)new GuiTransparentButton(10, 40, 110, 20, I18n.func_135052_a((String)"string.naturescompass.startSearch", (Object[])new Object[0]), onPress -> {
            if (this.selectionList.hasSelection()) {
                ((BiomeSearchEntry)this.selectionList.getSelected()).searchForBiome();
            }
        }));
        this.teleportButton = (Button)this.addButton((Widget)new GuiTransparentButton(this.width - 120, 10, 110, 20, I18n.func_135052_a((String)"string.naturescompass.teleport", (Object[])new Object[0]), onPress -> this.teleport()));
        this.startSearchButton.active = false;
        this.infoButton.active = false;
        this.teleportButton.visible = NaturesCompass.canTeleport;
    }

    private void setupTextFields() {
        this.searchTextField = new GuiTransparentTextField(this.font, 130, 10, 140, 20, I18n.func_135052_a((String)"string.naturescompass.search", (Object[])new Object[0]));
        this.children.add(this.searchTextField);
    }
}

