/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.naturescompass.gui;

import com.chaosthedude.naturescompass.gui.BiomeSearchEntry;
import com.chaosthedude.naturescompass.gui.NaturesCompassScreen;
import com.chaosthedude.naturescompass.util.RenderUtils;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.gui.widget.list.ExtendedList;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BiomeSearchList
extends ExtendedList<BiomeSearchEntry> {
    private final NaturesCompassScreen guiNaturesCompass;

    public BiomeSearchList(NaturesCompassScreen guiNaturesCompass, Minecraft mc, int width, int height, int top, int bottom, int slotHeight) {
        super(mc, width, height, top, bottom, slotHeight);
        this.guiNaturesCompass = guiNaturesCompass;
        this.refreshList();
    }

    protected int getScrollbarPosition() {
        return super.getScrollbarPosition() + 20;
    }

    public int getRowWidth() {
        return super.getRowWidth() + 50;
    }

    protected boolean isSelectedItem(int slotIndex) {
        return slotIndex >= 0 && slotIndex < this.children().size() ? ((Object)((Object)((BiomeSearchEntry)((Object)this.children().get(slotIndex))))).equals(this.getSelected()) : false;
    }

    public void render(int par1, int par2, float par3) {
        int i = this.getScrollbarPosition();
        int k = this.getRowLeft();
        int l = this.y0 + 4 - (int)this.getScrollAmount();
        this.renderList(k, l, par1, par2, par3);
    }

    protected void renderList(int par1, int par2, int par3, int par4, float par5) {
        int i = this.getItemCount();
        for (int j = 0; j < i; ++j) {
            int k = this.getRowTop(j);
            int l = this.getRowBottom(j);
            if (l < this.y0 || k > this.y1) continue;
            int j1 = this.itemHeight - 4;
            BiomeSearchEntry e = (BiomeSearchEntry)this.getEntry(j);
            int k1 = this.getRowWidth();
            if (this.renderSelection && this.isSelectedItem(j)) {
                int insideLeft = this.x0 + this.width / 2 - this.getRowWidth() / 2 + 2;
                RenderUtils.drawRect(insideLeft - 4, k - 4, insideLeft + this.getRowWidth() + 4, k + this.itemHeight, 0x7F000000);
            }
            int j2 = this.getRowLeft();
            e.render(j, k, j2, k1, j1, par3, par4, this.isMouseOver(par3, par4) && Objects.equals(this.getEntryAtPosition(par3, par4), (Object)e), par5);
        }
    }

    private int getRowBottom(int p_getRowBottom_1_) {
        return this.getRowTop(p_getRowBottom_1_) + this.itemHeight;
    }

    public void refreshList() {
        this.clearEntries();
        for (Biome biome : this.guiNaturesCompass.sortBiomes()) {
            this.addEntry((AbstractList.AbstractListEntry)new BiomeSearchEntry(this, biome));
        }
        this.selectBiome(null);
    }

    public void selectBiome(BiomeSearchEntry entry) {
        this.setSelected((AbstractList.AbstractListEntry)entry);
        this.guiNaturesCompass.selectBiome(entry);
    }

    public boolean hasSelection() {
        return this.getSelected() != null;
    }

    public NaturesCompassScreen getGuiNaturesCompass() {
        return this.guiNaturesCompass;
    }
}

