/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.cucumber.lib;

import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;

public class Pos3d
extends Vec3d {
    public Pos3d() {
        this(0.0, 0.0, 0.0);
    }

    public Pos3d(Vec3d vec) {
        super(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
    }

    public Pos3d(Vec3i vec) {
        super(vec);
    }

    public Pos3d(RayTraceResult mop) {
        this(mop.func_216347_e());
    }

    public Pos3d(double x, double y, double z) {
        super(x, y, z);
    }

    public Pos3d(Entity entity) {
        this(entity.func_180425_c().func_177958_n(), entity.func_180425_c().func_177956_o(), entity.func_180425_c().func_177952_p());
    }

    public Pos3d(TileEntity tileEntity) {
        this((Vec3i)tileEntity.func_174877_v());
    }

    public static Pos3d read(CompoundNBT tag) {
        return new Pos3d(tag.func_74769_h("x"), tag.func_74769_h("y"), tag.func_74769_h("z"));
    }

    public CompoundNBT write(CompoundNBT tag) {
        tag.func_74780_a("x", this.field_72450_a);
        tag.func_74780_a("y", this.field_72448_b);
        tag.func_74780_a("z", this.field_72449_c);
        return tag;
    }

    public Pos3d diff(Vec3d vec) {
        return new Pos3d(this.field_72450_a - vec.field_72450_a, this.field_72448_b - vec.field_72448_b, this.field_72449_c - vec.field_72449_c);
    }

    public static Pos3d fromMotion(Entity entity) {
        return new Pos3d(entity.func_213322_ci().func_82615_a(), entity.func_213322_ci().func_82617_b(), entity.func_213322_ci().func_82616_c());
    }

    public Pos3d centre() {
        return this.translate(0.5, 0.5, 0.5);
    }

    public Pos3d translate(double x, double y, double z) {
        return new Pos3d(this.field_72450_a + x, this.field_72448_b + y, this.field_72449_c + z);
    }

    public Pos3d translate(Vec3d pos) {
        return this.translate(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
    }

    public Pos3d translate(Direction direction, double amount) {
        return this.translate((double)direction.func_176730_m().func_177958_n() * amount, (double)direction.func_176730_m().func_177956_o() * amount, (double)direction.func_176730_m().func_177952_p() * amount);
    }

    public Pos3d translateExcludingSide(Direction direction, double amount) {
        double xPos = this.field_72450_a;
        double yPos = this.field_72448_b;
        double zPos = this.field_72449_c;
        if (direction.func_176740_k() != Direction.Axis.X) {
            xPos += amount;
        }
        if (direction.func_176740_k() != Direction.Axis.Y) {
            yPos += amount;
        }
        if (direction.func_176740_k() != Direction.Axis.Z) {
            zPos += amount;
        }
        return new Pos3d(xPos, yPos, zPos);
    }

    public double distance(Vec3d pos) {
        double subX = this.field_72450_a - pos.field_72450_a;
        double subY = this.field_72448_b - pos.field_72448_b;
        double subZ = this.field_72449_c - pos.field_72449_c;
        return MathHelper.func_76133_a((double)(subX * subX + subY * subY + subZ * subZ));
    }

    public Pos3d rotateYaw(float yaw) {
        double yawRadians = Math.toRadians(yaw);
        double xPos = this.field_72450_a;
        double zPos = this.field_72449_c;
        if (yaw != 0.0f) {
            xPos = this.field_72450_a * Math.cos(yawRadians) - this.field_72449_c * Math.sin(yawRadians);
            zPos = this.field_72449_c * Math.cos(yawRadians) + this.field_72450_a * Math.sin(yawRadians);
        }
        return new Pos3d(xPos, this.field_72448_b, zPos);
    }

    public Pos3d rotatePitch(float pitch) {
        double pitchRadians = Math.toRadians(pitch);
        double yPos = this.field_72448_b;
        double zPos = this.field_72449_c;
        if (pitch != 0.0f) {
            yPos = this.field_72448_b * Math.cos(pitchRadians) - this.field_72449_c * Math.sin(pitchRadians);
            zPos = this.field_72449_c * Math.cos(pitchRadians) + this.field_72448_b * Math.sin(pitchRadians);
        }
        return new Pos3d(this.field_72450_a, yPos, zPos);
    }

    public Pos3d rotate(float yaw, float pitch) {
        return this.rotate(yaw, pitch, 0.0f);
    }

    public Pos3d rotate(float yaw, float pitch, float roll) {
        double yawRadians = Math.toRadians(yaw);
        double pitchRadians = Math.toRadians(pitch);
        double rollRadians = Math.toRadians(roll);
        double xPos = this.field_72450_a * Math.cos(yawRadians) * Math.cos(pitchRadians) + this.field_72449_c * (Math.cos(yawRadians) * Math.sin(pitchRadians) * Math.sin(rollRadians) - Math.sin(yawRadians) * Math.cos(rollRadians)) + this.field_72448_b * (Math.cos(yawRadians) * Math.sin(pitchRadians) * Math.cos(rollRadians) + Math.sin(yawRadians) * Math.sin(rollRadians));
        double zPos = this.field_72450_a * Math.sin(yawRadians) * Math.cos(pitchRadians) + this.field_72449_c * (Math.sin(yawRadians) * Math.sin(pitchRadians) * Math.sin(rollRadians) + Math.cos(yawRadians) * Math.cos(rollRadians)) + this.field_72448_b * (Math.sin(yawRadians) * Math.sin(pitchRadians) * Math.cos(rollRadians) - Math.cos(yawRadians) * Math.sin(rollRadians));
        double yPos = -this.field_72450_a * Math.sin(pitchRadians) + this.field_72449_c * Math.cos(pitchRadians) * Math.sin(rollRadians) + this.field_72448_b * Math.cos(pitchRadians) * Math.cos(rollRadians);
        return new Pos3d(xPos, yPos, zPos);
    }

    public Pos3d multiply(Vec3d pos) {
        return this.scale(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
    }

    public Pos3d scale(double x, double y, double z) {
        return new Pos3d(x * x, y * y, z * z);
    }

    public Pos3d scale(double scale) {
        return this.scale(scale, scale, scale);
    }

    public Pos3d rotate(float angle, Pos3d axis) {
        return Pos3d.translateMatrix(Pos3d.getRotationMatrix(angle, axis), this);
    }

    public double[] getRotationMatrix(float angle) {
        double[] matrix = new double[16];
        Pos3d axis = this.clone().normalize();
        double x = axis.field_72450_a;
        double y = axis.field_72448_b;
        double z = axis.field_72449_c;
        angle = (float)((double)angle * 0.0174532925);
        float cos = (float)Math.cos(angle);
        float ocos = 1.0f - cos;
        float sin = (float)Math.sin(angle);
        matrix[0] = x * x * (double)ocos + (double)cos;
        matrix[1] = y * x * (double)ocos + z * (double)sin;
        matrix[2] = x * z * (double)ocos - y * (double)sin;
        matrix[4] = x * y * (double)ocos - z * (double)sin;
        matrix[5] = y * y * (double)ocos + (double)cos;
        matrix[6] = y * z * (double)ocos + x * (double)sin;
        matrix[8] = x * z * (double)ocos + y * (double)sin;
        matrix[9] = y * z * (double)ocos - x * (double)sin;
        matrix[10] = z * z * (double)ocos + (double)cos;
        matrix[15] = 1.0;
        return matrix;
    }

    public static Pos3d translateMatrix(double[] matrix, Pos3d translation) {
        double x = translation.field_72450_a * matrix[0] + translation.field_72448_b * matrix[1] + translation.field_72449_c * matrix[2] + matrix[3];
        double y = translation.field_72450_a * matrix[4] + translation.field_72448_b * matrix[5] + translation.field_72449_c * matrix[6] + matrix[7];
        double z = translation.field_72450_a * matrix[8] + translation.field_72448_b * matrix[9] + translation.field_72449_c * matrix[10] + matrix[11];
        return new Pos3d(x, y, z);
    }

    public static double[] getRotationMatrix(float angle, Pos3d axis) {
        return axis.getRotationMatrix(angle);
    }

    public double anglePreNorm(Pos3d pos2) {
        return Math.acos(this.func_72430_b(pos2));
    }

    public static double anglePreNorm(Pos3d pos1, Pos3d pos2) {
        return Math.acos(pos1.clone().func_72430_b(pos2));
    }

    public Pos3d normalize() {
        return new Pos3d(super.func_72432_b());
    }

    public Pos3d xCrossProduct() {
        return new Pos3d(0.0, this.field_72449_c, -this.field_72448_b);
    }

    public Pos3d zCrossProduct() {
        return new Pos3d(-this.field_72448_b, this.field_72450_a, 0.0);
    }

    public Pos3d getPerpendicular() {
        if (this.field_72449_c == 0.0) {
            return this.zCrossProduct();
        }
        return this.xCrossProduct();
    }

    public Pos3d floor() {
        return new Pos3d(Math.floor(this.field_72450_a), Math.floor(this.field_72448_b), Math.floor(this.field_72449_c));
    }

    public static AxisAlignedBB getAABB(Pos3d pos1, Pos3d pos2) {
        return new AxisAlignedBB(pos1.field_72450_a, pos1.field_72448_b, pos1.field_72449_c, pos2.field_72450_a, pos2.field_72448_b, pos2.field_72449_c);
    }

    public Pos3d clone() {
        return new Pos3d(this.field_72450_a, this.field_72448_b, this.field_72449_c);
    }

    public String toString() {
        return "[Pos3D: " + this.field_72450_a + ", " + this.field_72448_b + ", " + this.field_72449_c + "]";
    }

    public boolean equals(Object obj) {
        return obj instanceof Vec3d && ((Vec3d)obj).field_72450_a == this.field_72450_a && ((Vec3d)obj).field_72450_a == this.field_72448_b && ((Vec3d)obj).field_72450_a == this.field_72449_c;
    }

    public int hashCode() {
        int code = 1;
        code = 31 * code + new Double(this.field_72450_a).hashCode();
        code = 31 * code + new Double(this.field_72448_b).hashCode();
        code = 31 * code + new Double(this.field_72449_c).hashCode();
        return code;
    }
}

