/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.cucumber.item;

import com.blakebr0.cucumber.item.BaseItem;
import com.blakebr0.cucumber.lib.Tooltips;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.enchantment.UnbreakingEnchantment;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;

public class ReusableItem
extends BaseItem {
    private boolean damage;
    private boolean tooltip;

    public ReusableItem(Function<Item.Properties, Item.Properties> properties) {
        this(true, properties);
    }

    public ReusableItem(boolean tooltip, Function<Item.Properties, Item.Properties> properties) {
        this(0, tooltip, properties);
    }

    public ReusableItem(int uses, Function<Item.Properties, Item.Properties> properties) {
        this(uses, true, properties);
    }

    public ReusableItem(int uses, boolean tooltip, Function<Item.Properties, Item.Properties> properties) {
        super(properties.compose(p -> p.func_200915_b(Math.max(uses - 1, 0)).setNoRepair()));
        this.damage = uses > 0;
        this.tooltip = tooltip;
    }

    public boolean hasContainerItem(ItemStack stack) {
        return true;
    }

    public ItemStack getContainerItem(ItemStack stack) {
        ItemStack copy = stack.func_77946_l();
        copy.func_190920_e(1);
        if (!this.damage) {
            return copy;
        }
        int unbreaking = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185307_s, (ItemStack)stack);
        for (int i = 0; i < unbreaking; ++i) {
            if (!UnbreakingEnchantment.func_92097_a((ItemStack)stack, (int)unbreaking, (Random)field_77697_d)) continue;
            return copy;
        }
        copy.func_196085_b(stack.func_77952_i() + 1);
        if (copy.func_77952_i() >= stack.func_77958_k()) {
            return ItemStack.field_190927_a;
        }
        return copy;
    }

    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag advanced) {
        if (this.tooltip) {
            if (this.damage) {
                int damage = stack.func_77958_k() - stack.func_77952_i() + 1;
                if (damage == 1) {
                    tooltip.add(Tooltips.ONE_USE_LEFT.build());
                } else {
                    tooltip.add(Tooltips.USES_LEFT.args(damage).build());
                }
            } else {
                tooltip.add(Tooltips.UNLIMITED_USES.build());
            }
        }
    }
}

