/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.theme;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import xiroc.dungeoncrawl.part.block.WeightedRandomBlock;
import xiroc.dungeoncrawl.theme.Theme;
import xiroc.dungeoncrawl.util.IBlockStateProvider;

public class JsonTheme {
    public JsonBaseTheme theme;
    public JsonSubTheme subTheme;
    private static final Logger LOGGER = LogManager.getLogger((String)"DungeonCrawl/JsonThemeDeserializer");

    public static IBlockStateProvider deserialize(JsonObject base, String name) {
        if (!base.has(name)) {
            LOGGER.error("Missing BlockState Provider \"{}\"", (Object)name);
            return null;
        }
        JsonObject object = (JsonObject)base.get(name);
        if (object.has("type")) {
            String type = object.get("type").getAsString();
            if (type.equalsIgnoreCase("WeightedRandomBlock")) {
                JsonArray blockObjects = object.get("blocks").getAsJsonArray();
                TupleIntBlock[] blocks = new TupleIntBlock[blockObjects.size()];
                int i = 0;
                for (JsonObject element : blockObjects) {
                    blocks[i++] = new TupleIntBlock(element.get("weight").getAsInt(), (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(element.get("block").getAsString())));
                }
                return WeightedRandomBlock.of(blocks);
            }
            if (type.equalsIgnoreCase("Block")) {
                BlockState state = ((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(object.get("block").getAsString()))).func_176223_P();
                return () -> state;
            }
            LOGGER.error("Failed to load BlockState Provider {}: Unknown type {}.", (Object)object, (Object)type);
            return null;
        }
        LOGGER.error("Failed to load a BlockState Provider: Type not specified.");
        return null;
    }

    private static final class TupleIntBlock
    extends Tuple<Integer, Block> {
        public TupleIntBlock(Integer aIn, Block bIn) {
            super((Object)aIn, (Object)bIn);
        }
    }

    public static class JsonSubTheme {
        public IBlockStateProvider wallLog;
        public IBlockStateProvider trapDoor;
        public IBlockStateProvider torchDark;
        public IBlockStateProvider door;
        public IBlockStateProvider material;

        public Theme.SubTheme toSubTheme() {
            return new Theme.SubTheme(this.wallLog, this.trapDoor, this.torchDark, this.door, this.material);
        }

        public static class Deserializer
        implements JsonDeserializer<JsonSubTheme> {
            public JsonSubTheme deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                JsonObject object = json.getAsJsonObject();
                JsonSubTheme theme = new JsonSubTheme();
                theme.wallLog = JsonTheme.deserialize(object, "wallLog");
                theme.trapDoor = JsonTheme.deserialize(object, "trapDoor");
                theme.torchDark = JsonTheme.deserialize(object, "torch");
                theme.door = JsonTheme.deserialize(object, "door");
                theme.material = JsonTheme.deserialize(object, "material");
                return theme;
            }
        }
    }

    public static class JsonBaseTheme {
        public IBlockStateProvider wall;
        public IBlockStateProvider floor;
        public IBlockStateProvider stairs;
        public IBlockStateProvider material;
        public IBlockStateProvider vanillaWall;
        public IBlockStateProvider column;

        public Theme toTheme() {
            return new Theme(null, this.wall, this.floor, this.stairs, this.material, this.vanillaWall, this.column);
        }

        public static class Deserializer
        implements JsonDeserializer<JsonBaseTheme> {
            public JsonBaseTheme deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                JsonObject object = json.getAsJsonObject();
                JsonBaseTheme theme = new JsonBaseTheme();
                theme.wall = JsonTheme.deserialize(object, "wall");
                theme.floor = JsonTheme.deserialize(object, "floor");
                theme.stairs = JsonTheme.deserialize(object, "stairs");
                theme.material = JsonTheme.deserialize(object, "material");
                theme.vanillaWall = JsonTheme.deserialize(object, "vanillaWall");
                theme.column = JsonTheme.deserialize(object, "column");
                return theme;
            }
        }
    }
}

