/*
 * Decompiled with CFR 0.152.
 */
package com.maciej916.maenchants.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class MeltedCobblestone
extends Block {
    public static final IntegerProperty AGE = BlockStateProperties.field_208168_U;

    public MeltedCobblestone(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)AGE, (Comparable)Integer.valueOf(0)));
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        if ((random.nextInt(3) == 0 || this.shouldMelt((IBlockReader)worldIn, pos, 4)) && worldIn.func_201696_r(pos) > 11 - (Integer)state.func_177229_b((IProperty)AGE) - state.func_200016_a((IBlockReader)worldIn, pos) && this.slightlyMelt(state, (World)worldIn, pos)) {
            try (BlockPos.PooledMutable blockpos$pooledmutable = BlockPos.PooledMutable.func_185346_s();){
                for (Direction direction : Direction.values()) {
                    blockpos$pooledmutable.func_189533_g((Vec3i)pos).func_189536_c(direction);
                    BlockState blockstate = worldIn.func_180495_p((BlockPos)blockpos$pooledmutable);
                    if (blockstate.func_177230_c() != this || this.slightlyMelt(blockstate, (World)worldIn, (BlockPos)blockpos$pooledmutable)) continue;
                    worldIn.func_205220_G_().func_205360_a((BlockPos)blockpos$pooledmutable, (Object)this, MathHelper.func_76136_a((Random)random, (int)20, (int)40));
                }
            }
        } else {
            worldIn.func_205220_G_().func_205360_a(pos, (Object)this, MathHelper.func_76136_a((Random)random, (int)20, (int)40));
        }
    }

    private boolean slightlyMelt(BlockState state, World worldIn, BlockPos pos) {
        int i = (Integer)state.func_177229_b((IProperty)AGE);
        if (i < 3) {
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)AGE, (Comparable)Integer.valueOf(i + 1)), 2);
            return false;
        }
        this.turnIntoLava(state, worldIn, pos);
        return true;
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (blockIn == this && this.shouldMelt((IBlockReader)worldIn, pos, 2)) {
            this.turnIntoLava(state, worldIn, pos);
        }
        super.func_220069_a(state, worldIn, pos, blockIn, fromPos, isMoving);
    }

    private boolean shouldMelt(IBlockReader worldIn, BlockPos pos, int neighborsRequired) {
        int i = 0;
        try (BlockPos.PooledMutable blockpos$pooledmutable = BlockPos.PooledMutable.func_185346_s();){
            boolean var24;
            for (Direction direction : Direction.values()) {
                boolean flag;
                boolean var12;
                blockpos$pooledmutable.func_189533_g((Vec3i)pos).func_189536_c(direction);
                if (worldIn.func_180495_p((BlockPos)blockpos$pooledmutable).func_177230_c() != this || ++i < neighborsRequired) continue;
                boolean bl = var12 = (flag = false);
                return bl;
            }
            boolean bl = var24 = true;
            return bl;
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{AGE});
    }

    public ItemStack func_185473_a(IBlockReader worldIn, BlockPos pos, BlockState state) {
        return ItemStack.field_190927_a;
    }

    protected void turnIntoLava(BlockState p_196454_1_, World p_196454_2_, BlockPos p_196454_3_) {
        p_196454_2_.func_175656_a(p_196454_3_, Blocks.field_150353_l.func_176223_P());
        p_196454_2_.func_190524_a(p_196454_3_, Blocks.field_150353_l, p_196454_3_);
    }

    public void func_180657_a(World worldIn, PlayerEntity player, BlockPos pos, BlockState state, @Nullable TileEntity te, ItemStack stack) {
        super.func_180657_a(worldIn, player, pos, state, te, stack);
        Material material = worldIn.func_180495_p(pos.func_177977_b()).func_185904_a();
        if (material.func_76230_c() || material.func_76224_d()) {
            worldIn.func_175656_a(pos, Blocks.field_150353_l.func_176223_P());
        }
    }
}

