/*
 * Decompiled with CFR 0.152.
 */
package com.maciej916.maenchants;

import com.google.common.base.Preconditions;
import com.maciej916.maenchants.block.MeltedCobblestone;
import com.maciej916.maenchants.config.ConfigHelper;
import com.maciej916.maenchants.curse.CurseAquaphobia;
import com.maciej916.maenchants.curse.CurseBreaking;
import com.maciej916.maenchants.curse.CurseButterfingers;
import com.maciej916.maenchants.curse.CurseDeath;
import com.maciej916.maenchants.enchantment.EnchantmentBlazingWalker;
import com.maciej916.maenchants.enchantment.EnchantmentButchering;
import com.maciej916.maenchants.enchantment.EnchantmentCombo;
import com.maciej916.maenchants.enchantment.EnchantmentDetonation;
import com.maciej916.maenchants.enchantment.EnchantmentFasterAttack;
import com.maciej916.maenchants.enchantment.EnchantmentFloating;
import com.maciej916.maenchants.enchantment.EnchantmentIceAspect;
import com.maciej916.maenchants.enchantment.EnchantmentLifesteal;
import com.maciej916.maenchants.enchantment.EnchantmentLumberjack;
import com.maciej916.maenchants.enchantment.EnchantmentMomentum;
import com.maciej916.maenchants.enchantment.EnchantmentMultiJump;
import com.maciej916.maenchants.enchantment.EnchantmentNightVision;
import com.maciej916.maenchants.enchantment.EnchantmentParalysis;
import com.maciej916.maenchants.enchantment.EnchantmentQuickDraw;
import com.maciej916.maenchants.enchantment.EnchantmentReinforcedTip;
import com.maciej916.maenchants.enchantment.EnchantmentStepAssist;
import com.maciej916.maenchants.enchantment.EnchantmentStoneMending;
import com.maciej916.maenchants.enchantment.EnchantmentTimeless;
import com.maciej916.maenchants.enchantment.EnchantmentTrueShot;
import com.maciej916.maenchants.enchantment.EnchantmentWisdom;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jline.utils.Log;

@Mod.EventBusSubscriber(modid="ma-enchants", bus=Mod.EventBusSubscriber.Bus.MOD)
public final class ModEventSubscriber {
    @SubscribeEvent
    public static void onModConfigEvent(ModConfig.ModConfigEvent event) {
        ModConfig config = event.getConfig();
        ConfigHelper.bake(config);
        Log.debug((Object[])new Object[]{"Baked config"});
    }

    @SubscribeEvent
    public static void onRegisterBlocks(RegistryEvent.Register<Block> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Block[]{ModEventSubscriber.setup(new MeltedCobblestone(Block.Properties.func_200949_a((Material)Material.field_151573_f, (MaterialColor)MaterialColor.field_151668_h).func_200948_a(5.0f, 6.0f).func_200947_a(SoundType.field_185851_d)), "melted_cobblestone")});
    }

    @SubscribeEvent
    public static void registerEnchantments(RegistryEvent.Register<Enchantment> event) {
        IForgeRegistry registry = event.getRegistry();
        registry.registerAll((IForgeRegistryEntry[])new Enchantment[]{ModEventSubscriber.setup(new CurseBreaking(), "curse_breaking"), ModEventSubscriber.setup(new CurseButterfingers(), "curse_butterfingers"), ModEventSubscriber.setup(new CurseAquaphobia(), "curse_aquaphobia"), ModEventSubscriber.setup(new CurseDeath(), "curse_death"), ModEventSubscriber.setup(new EnchantmentReinforcedTip(), "reinforced_tip"), ModEventSubscriber.setup(new EnchantmentStoneMending(), "stone_mending"), ModEventSubscriber.setup(new EnchantmentLumberjack(), "lumberjack"), ModEventSubscriber.setup(new EnchantmentMomentum(), "momentum"), ModEventSubscriber.setup(new EnchantmentButchering(), "butchering"), ModEventSubscriber.setup(new EnchantmentTrueShot(), "true_shot"), ModEventSubscriber.setup(new EnchantmentQuickDraw(), "quick_draw"), ModEventSubscriber.setup(new EnchantmentFloating(), "floating"), ModEventSubscriber.setup(new EnchantmentParalysis(), "paralysis"), ModEventSubscriber.setup(new EnchantmentDetonation(), "detonation"), ModEventSubscriber.setup(new EnchantmentCombo(), "combo"), ModEventSubscriber.setup(new EnchantmentFasterAttack(), "faster_attack"), ModEventSubscriber.setup(new EnchantmentLifesteal(), "lifesteal"), ModEventSubscriber.setup(new EnchantmentIceAspect(), "ice_aspect"), ModEventSubscriber.setup(new EnchantmentWisdom(), "wisdom"), ModEventSubscriber.setup(new EnchantmentBlazingWalker(), "blazing_walker"), ModEventSubscriber.setup(new EnchantmentStepAssist(), "step_assist"), ModEventSubscriber.setup(new EnchantmentNightVision(), "night_vision"), ModEventSubscriber.setup(new EnchantmentMultiJump(), "multi_jump"), ModEventSubscriber.setup(new EnchantmentTimeless(), "timeless")});
    }

    @Nonnull
    private static <T extends IForgeRegistryEntry<T>> T setup(@Nonnull T entry, @Nonnull String name) {
        return ModEventSubscriber.setup(entry, new ResourceLocation("ma-enchants", name));
    }

    @Nonnull
    private static <T extends IForgeRegistryEntry<T>> T setup(@Nonnull T entry, @Nonnull ResourceLocation registryName) {
        Preconditions.checkNotNull(entry, (Object)"Entry cannot be null!");
        Preconditions.checkNotNull((Object)registryName, (Object)"Registry name to assign to entry cannot be null!");
        entry.setRegistryName(registryName);
        return entry;
    }
}

