/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.abnormals_core.core.library;

import com.teamabnormals.abnormals_core.core.library.endimator.EndimatorModelRenderer;
import java.util.function.BiConsumer;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.util.math.Vec3d;

public class SimpleTransform {
    public static final SimpleTransform ZERO = new SimpleTransform(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
    private float posX;
    private float posY;
    private float posZ;
    private float offsetX;
    private float offsetY;
    private float offsetZ;
    private float angleX;
    private float angleY;
    private float angleZ;
    private float scaleX;
    private float scaleY;
    private float scaleZ;

    public SimpleTransform(float posX, float posY, float posZ, float angleX, float angleY, float angleZ) {
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
        this.angleX = angleX;
        this.angleY = angleY;
        this.angleZ = angleZ;
    }

    public SimpleTransform(float posX, float posY, float posZ, float offsetX, float offsetY, float offsetZ, float angleX, float angleY, float angleZ) {
        this(posX, posY, posZ, angleX, angleY, angleZ);
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.offsetZ = offsetZ;
    }

    public SimpleTransform(float posX, float posY, float posZ, float offsetX, float offsetY, float offsetZ, float angleX, float angleY, float angleZ, float scaleX, float scaleY, float scaleZ) {
        this(posX, posY, posZ, angleX, angleY, angleZ);
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.offsetZ = offsetZ;
        this.scaleX = scaleX;
        this.scaleY = scaleY;
        this.scaleZ = scaleZ;
    }

    public static SimpleTransform copy(SimpleTransform transform) {
        return new SimpleTransform(transform.posX, transform.posY, transform.posZ, transform.offsetY, transform.offsetY, transform.offsetZ, transform.angleX, transform.angleY, transform.angleZ, transform.scaleX, transform.scaleY, transform.scaleZ);
    }

    public void scale(Vec3d scale) {
        this.setPosition(this.posX * (float)scale.func_82615_a(), this.posX * (float)scale.func_82617_b(), this.posX * (float)scale.func_82616_c());
    }

    public void setPosition(float posX, float posY, float posZ) {
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
    }

    public void addPosition(float posX, float posY, float posZ) {
        this.posX += posX;
        this.posY += posY;
        this.posZ += posZ;
    }

    public void setOffset(float offsetX, float offsetY, float offsetZ) {
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.offsetZ = offsetZ;
    }

    public void addOffset(float offsetX, float offsetY, float offsetZ) {
        this.offsetX += offsetX;
        this.offsetY += offsetY;
        this.offsetZ += offsetZ;
    }

    public void setRotation(float angleX, float angleY, float angleZ) {
        this.angleX = angleX;
        this.angleY = angleY;
        this.angleZ = angleZ;
    }

    public void addRotation(float angleX, float angleY, float angleZ) {
        this.angleX += angleX;
        this.angleY += angleY;
        this.angleZ += angleZ;
    }

    public void setScale(float scaleX, float scaleY, float scaleZ) {
        this.scaleX = scaleX;
        this.scaleY = scaleY;
        this.scaleZ = scaleZ;
    }

    public void addScale(float scaleX, float scaleY, float scaleZ) {
        this.scaleX += scaleX;
        this.scaleY += scaleY;
        this.scaleZ += scaleZ;
    }

    public void applyTransformToModelRenderer(ModelRenderer modelRenderer) {
        modelRenderer.field_78800_c = this.posX;
        modelRenderer.field_78797_d = this.posY;
        modelRenderer.field_78798_e = this.posZ;
        modelRenderer.field_78795_f = this.angleX;
        modelRenderer.field_78796_g = this.angleY;
        modelRenderer.field_78808_h = this.angleZ;
    }

    public void applyTransformToEndimatorModelRenderer(EndimatorModelRenderer modelRenderer) {
        modelRenderer.field_78800_c = this.posX;
        modelRenderer.field_78797_d = this.posY;
        modelRenderer.field_78798_e = this.posZ;
        modelRenderer.offsetX = this.offsetX;
        modelRenderer.offsetY = this.offsetY;
        modelRenderer.offsetZ = this.offsetZ;
        modelRenderer.field_78795_f = this.angleX;
        modelRenderer.field_78796_g = this.angleY;
        modelRenderer.field_78808_h = this.angleZ;
        modelRenderer.setScale(this.scaleX, this.scaleY, this.scaleZ);
    }

    public static BiConsumer<ModelRenderer, SimpleTransform> applyTransformToModelRenderer() {
        return (modelRenderer, transform) -> transform.applyTransformToModelRenderer((ModelRenderer)modelRenderer);
    }

    public static BiConsumer<EndimatorModelRenderer, SimpleTransform> applyTransformToEndimatorModelRenderer() {
        return (modelRenderer, transform) -> transform.applyTransformToEndimatorModelRenderer((EndimatorModelRenderer)((Object)modelRenderer));
    }

    public void applyAdditiveTransformToModelRenderer(ModelRenderer modelRenderer) {
        modelRenderer.field_78800_c += this.posX;
        modelRenderer.field_78797_d += this.posY;
        modelRenderer.field_78798_e += this.posZ;
        modelRenderer.field_78795_f += this.angleX;
        modelRenderer.field_78796_g += this.angleY;
        modelRenderer.field_78808_h += this.angleZ;
    }

    public static BiConsumer<ModelRenderer, SimpleTransform> applyAdditiveTransformToModelRenderer() {
        return (modelRenderer, transform) -> transform.applyAdditiveTransformToModelRenderer((ModelRenderer)modelRenderer);
    }

    public void applyAdditiveTransformToEndimatorModelRenderer(EndimatorModelRenderer modelRenderer) {
        modelRenderer.field_78800_c += this.posX;
        modelRenderer.field_78797_d += this.posY;
        modelRenderer.field_78798_e += this.posZ;
        modelRenderer.offsetX += this.offsetX;
        modelRenderer.offsetY += this.offsetY;
        modelRenderer.offsetZ += this.offsetZ;
        modelRenderer.field_78795_f += this.angleX;
        modelRenderer.field_78796_g += this.angleY;
        modelRenderer.field_78808_h += this.angleZ;
        modelRenderer.scaleX += this.scaleX;
        modelRenderer.scaleY += this.scaleY;
        modelRenderer.scaleZ += this.scaleZ;
    }

    public static BiConsumer<EndimatorModelRenderer, SimpleTransform> applyAdditiveTransformToEndimatorModelRenderer() {
        return (modelRenderer, transform) -> transform.applyAdditiveTransformToEndimatorModelRenderer((EndimatorModelRenderer)((Object)modelRenderer));
    }

    public void applyAdditiveTransformToModelRendererWithMultiplier(ModelRenderer modelRenderer, float multiplier) {
        modelRenderer.field_78800_c += multiplier * this.posX;
        modelRenderer.field_78797_d += multiplier * this.posY;
        modelRenderer.field_78798_e += multiplier * this.posZ;
        modelRenderer.field_78795_f += multiplier * this.angleX;
        modelRenderer.field_78796_g += multiplier * this.angleY;
        modelRenderer.field_78808_h += multiplier * this.angleZ;
    }

    public static BiConsumer<ModelRenderer, SimpleTransform> applyAdditiveTransformToModelRendererWithMultiplier(float multiplier) {
        return (modelRenderer, transform) -> transform.applyAdditiveTransformToModelRendererWithMultiplier((ModelRenderer)modelRenderer, multiplier);
    }

    public void applyAdditiveTransformToEndimatorModelRendererWithMultiplier(EndimatorModelRenderer modelRenderer, float multiplier) {
        modelRenderer.field_78800_c += multiplier * this.posX;
        modelRenderer.field_78797_d += multiplier * this.posY;
        modelRenderer.field_78798_e += multiplier * this.posZ;
        modelRenderer.offsetX += multiplier * this.offsetX;
        modelRenderer.offsetY += multiplier * this.offsetY;
        modelRenderer.offsetZ += multiplier * this.offsetZ;
        modelRenderer.field_78795_f += multiplier * this.angleX;
        modelRenderer.field_78796_g += multiplier * this.angleY;
        modelRenderer.field_78808_h += multiplier * this.angleZ;
        modelRenderer.scaleX += multiplier * this.scaleX;
        modelRenderer.scaleY += multiplier * this.scaleY;
        modelRenderer.scaleZ += multiplier * this.scaleZ;
    }

    public static BiConsumer<EndimatorModelRenderer, SimpleTransform> applyAdditiveTransformToEndimatorModelRendererWithMultiplier(float multiplier) {
        return (modelRenderer, transform) -> transform.applyAdditiveTransformToEndimatorModelRendererWithMultiplier((EndimatorModelRenderer)((Object)modelRenderer), multiplier);
    }

    public float getPosX() {
        return this.posX;
    }

    public float getPosY() {
        return this.posY;
    }

    public float getPosZ() {
        return this.posZ;
    }

    public float getOffsetX() {
        return this.offsetX;
    }

    public float getOffsetY() {
        return this.offsetY;
    }

    public float getOffsetZ() {
        return this.offsetZ;
    }

    public float getAngleX() {
        return this.angleX;
    }

    public float getAngleY() {
        return this.angleY;
    }

    public float getAngleZ() {
        return this.angleZ;
    }

    public float getScaleX() {
        return this.scaleX;
    }

    public float getScaleY() {
        return this.scaleY;
    }

    public float getScaleZ() {
        return this.scaleZ;
    }
}

