/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.abnormals_core.core.config;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public class ACConfig {
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final Common COMMON;

    private static String makeTranslation(String name) {
        return "abnormals_core.config." + name;
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class ValuesHolder {
        private static boolean quarkSignEditing;
        private static boolean signEditingRequireEmptyHand;

        public static void updateCommonValuesFromConfig(ModConfig config) {
            quarkSignEditing = (Boolean)ACConfig.COMMON.enableQuarkSignEditing.get();
            signEditingRequireEmptyHand = (Boolean)ACConfig.COMMON.signEditingRequiresEmptyHand.get();
        }

        public static boolean isQuarkSignEditingEnabled() {
            return ModList.get().isLoaded("quark") && quarkSignEditing;
        }

        public static boolean doesSignEditingRequireEmptyHand() {
            return signEditingRequireEmptyHand;
        }
    }

    public static class Common {
        public final ForgeConfigSpec.ConfigValue<Boolean> enableQuarkSignEditing;
        public final ForgeConfigSpec.ConfigValue<Boolean> signEditingRequiresEmptyHand;

        Common(ForgeConfigSpec.Builder builder) {
            builder.comment("Common only settings for Abnormals Core, this will affect all depending mods").push("common");
            this.enableQuarkSignEditing = builder.comment("If Quark Sign Editing should be enabled; Default: True").translation(ACConfig.makeTranslation("quark_sign_editing")).define("quarkSignEditing", true);
            this.signEditingRequiresEmptyHand = builder.comment("If Quark Sign Editing requires an empty hand to edit; Default: False").translation(ACConfig.makeTranslation("require_empty_hand")).define("signEditingRequiresEmptyHand", false);
            builder.pop();
        }
    }
}

