/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.recipes;

import com.google.common.base.Strings;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.utils.MiscHelper;

public class ShapedRecipeSupplier
implements Supplier<ShapedRecipe> {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final String group;
    public final Object output;
    public final int count;
    public final Object[] input;

    public ShapedRecipeSupplier(ResourceLocation key, Object output, int count, Object ... input) {
        this(key, "", output, count, input);
    }

    public ShapedRecipeSupplier(ResourceLocation key, String group, Object output, int count, Object ... input) {
        this.key = Objects.requireNonNull(key);
        this.group = Strings.nullToEmpty((String)group);
        this.output = output;
        this.count = count;
        this.input = Objects.requireNonNull(input);
    }

    @Override
    public ShapedRecipe get() {
        ItemStack stack = MiscHelper.INSTANCE.getItemStack(this.output, this.count);
        if (stack.func_190926_b()) {
            LOGGER.warn("Empty output in recipe {}: {}", (Object)this.key, this.output);
        }
        int width = 0;
        int height = 0;
        String shape = "";
        int idx = 0;
        if (this.input[idx] instanceof String[]) {
            String[] parts;
            for (String s : parts = (String[])this.input[idx++]) {
                width = s.length();
                shape = shape + s;
            }
            height = parts.length;
        } else {
            while (this.input[idx] instanceof String) {
                String s = (String)this.input[idx++];
                shape = shape + s;
                width = s.length();
                ++height;
            }
        }
        if (width * height != shape.length() || shape.length() == 0) {
            throw new IllegalArgumentException("Invalid shape in recipe " + this.key + ": " + shape + "," + width + "x" + height);
        }
        HashMap<Character, Ingredient> itemMap = new HashMap<Character, Ingredient>();
        itemMap.put(Character.valueOf(' '), Ingredient.field_193370_a);
        while (idx < this.input.length) {
            Character chr = (Character)this.input[idx];
            Object in = this.input[idx + 1];
            Ingredient ing = MiscHelper.INSTANCE.getIngredient(in);
            if (' ' == chr.charValue()) {
                throw new IllegalArgumentException("Invalid key entry in recipe " + this.key + ": ' ' is a reserved symbol");
            }
            if (ing.func_203189_d()) {
                LOGGER.warn("Empty ingredient in recipe {}: {}", (Object)this.key, in);
            }
            itemMap.put(chr, ing);
            idx += 2;
        }
        NonNullList inputList = NonNullList.func_191197_a((int)(width * height), (Object)Ingredient.field_193370_a);
        int x = 0;
        for (char chr : shape.toCharArray()) {
            Ingredient ing = (Ingredient)itemMap.get(Character.valueOf(chr));
            if (ing == null) {
                throw new IllegalArgumentException("Pattern in recipe " + this.key + " references symbol '" + chr + "' but it's not defined in the key");
            }
            inputList.set(x++, (Object)ing);
        }
        return new ShapedRecipe(this.key, this.group, width, height, inputList, stack);
    }
}

