/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.modules.passive;

import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import java.util.Collections;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import thelm.jaopca.api.forms.IForm;
import thelm.jaopca.api.forms.IFormRequest;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.modules.IModule;
import thelm.jaopca.api.modules.IModuleData;
import thelm.jaopca.api.modules.JAOPCAModule;
import thelm.jaopca.items.ItemFormType;
import thelm.jaopca.utils.ApiImpl;
import thelm.jaopca.utils.MiscHelper;

@JAOPCAModule
public class TinyDustsModule
implements IModule {
    private final IForm tinyDustForm = ApiImpl.INSTANCE.newForm(this, "tiny_dusts", ItemFormType.INSTANCE);

    @Override
    public String getName() {
        return "tiny_dusts";
    }

    @Override
    public boolean isPassive() {
        return true;
    }

    @Override
    public Multimap<Integer, String> getModuleDependencies() {
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        builder.put((Object)0, (Object)"dusts");
        return builder.build();
    }

    @Override
    public List<IFormRequest> getFormRequests() {
        return Collections.singletonList(this.tinyDustForm.toRequest());
    }

    @Override
    public void onCommonSetup(IModuleData moduleData, FMLCommonSetupEvent event) {
        ApiImpl api = ApiImpl.INSTANCE;
        MiscHelper miscHelper = MiscHelper.INSTANCE;
        for (IMaterial material : this.tinyDustForm.getMaterials()) {
            ResourceLocation dustLocation = miscHelper.getTagLocation("dusts", material.getName());
            ResourceLocation tinyDustLocation = miscHelper.getTagLocation("tiny_dusts", material.getName());
            ApiImpl.INSTANCE.registerShapelessRecipe(new ResourceLocation("jaopca", "tiny_dusts.to_dust." + material.getName()), dustLocation, 1, tinyDustLocation, tinyDustLocation, tinyDustLocation, tinyDustLocation, tinyDustLocation, tinyDustLocation, tinyDustLocation, tinyDustLocation, tinyDustLocation);
        }
    }
}

