/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.mekanism.recipes;

import java.util.Objects;
import java.util.function.Supplier;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.recipes.inputs.GasStackIngredient;
import mekanism.api.recipes.inputs.ItemStackIngredient;
import mekanism.common.recipe.impl.ItemStackGasToGasIRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.compat.mekanism.MekanismHelper;
import thelm.jaopca.utils.MiscHelper;

public class DissolutionRecipeSupplier
implements Supplier<ItemStackGasToGasIRecipe> {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object itemInput;
    public final int itemInputCount;
    public final Object gasInput;
    public final int gasInputCount;
    public final Object output;
    public final int outputCount;

    public DissolutionRecipeSupplier(ResourceLocation key, Object itemInput, int itemInputCount, Object gasInput, int gasInputCount, Object output, int outputCount) {
        this.key = Objects.requireNonNull(key);
        this.itemInput = itemInput;
        this.itemInputCount = itemInputCount;
        this.gasInput = gasInput;
        this.gasInputCount = gasInputCount;
        this.output = output;
        this.outputCount = outputCount;
    }

    @Override
    public ItemStackGasToGasIRecipe get() {
        Ingredient ing = MiscHelper.INSTANCE.getIngredient(this.itemInput);
        if (ing.func_203189_d()) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + this.itemInput);
        }
        GasStackIngredient gasIng = MekanismHelper.INSTANCE.getGasStackIngredient(this.gasInput, this.gasInputCount);
        GasStack stack = MekanismHelper.INSTANCE.getGasStack(this.output, this.outputCount);
        if (stack.isEmpty()) {
            LOGGER.warn("Empty output in recipe {}: {}", (Object)this.key, this.output);
        }
        return new ItemStackGasToGasIRecipe(this.key, ItemStackIngredient.from((Ingredient)ing, (int)this.itemInputCount), gasIng, stack);
    }
}

