/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.mekanism.gases;

import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasBuilder;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import thelm.jaopca.api.forms.IForm;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.compat.mekanism.api.gases.IGasFormSettings;
import thelm.jaopca.compat.mekanism.api.gases.IMaterialFormGas;
import thelm.jaopca.utils.ApiImpl;

public class JAOPCAGas
extends Gas
implements IMaterialFormGas {
    private final IForm form;
    private final IMaterial material;
    protected final IGasFormSettings settings;
    protected boolean isHidden;

    public JAOPCAGas(IForm form, IMaterial material, IGasFormSettings settings) {
        super(GasBuilder.builder((ResourceLocation)new ResourceLocation("jaopca", "gas/" + material.getModelType() + '/' + form.getName())));
        this.form = form;
        this.material = material;
        this.settings = settings;
        this.isHidden = settings.getIsHidden();
    }

    @Override
    public IForm getForm() {
        return this.form;
    }

    @Override
    public IMaterial getMaterial() {
        return this.material;
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public int getTint() {
        return 0xFFFFFF & this.material.getColor();
    }

    public ITextComponent getTextComponent() {
        return ApiImpl.INSTANCE.currentLocalizer().localizeMaterialForm("gas.jaopca." + this.form.getName(), this.material, this.getTranslationKey());
    }
}

