/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.flux;

import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import thelm.jaopca.api.forms.IForm;
import thelm.jaopca.api.forms.IFormRequest;
import thelm.jaopca.api.items.IItemInfo;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.materials.MaterialType;
import thelm.jaopca.api.modules.IModule;
import thelm.jaopca.api.modules.IModuleData;
import thelm.jaopca.api.modules.JAOPCAModule;
import thelm.jaopca.compat.flux.FluxHelper;
import thelm.jaopca.items.ItemFormType;
import thelm.jaopca.utils.ApiImpl;
import thelm.jaopca.utils.MiscHelper;

@JAOPCAModule(modDependencies={"flux@[4.8.4,)"})
public class FluxModule
implements IModule {
    private static final Set<String> BLACKLIST = new TreeSet<String>(Arrays.asList("copper", "gold", "iron", "tin"));
    private final IForm gritForm = ApiImpl.INSTANCE.newForm(this, "flux_grits", ItemFormType.INSTANCE).setMaterialTypes(MaterialType.INGOT).setSecondaryName("grits").setDefaultMaterialBlacklist(BLACKLIST);

    @Override
    public String getName() {
        return "flux";
    }

    @Override
    public Multimap<Integer, String> getModuleDependencies() {
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        builder.put((Object)0, (Object)"dusts");
        return builder.build();
    }

    @Override
    public List<IFormRequest> getFormRequests() {
        return Collections.singletonList(this.gritForm.toRequest());
    }

    @Override
    public Set<MaterialType> getMaterialTypes() {
        return EnumSet.of(MaterialType.INGOT);
    }

    @Override
    public Set<String> getDefaultMaterialBlacklist() {
        return BLACKLIST;
    }

    @Override
    public void onCommonSetup(IModuleData moduleData, FMLCommonSetupEvent event) {
        ResourceLocation oreLocation;
        ApiImpl api = ApiImpl.INSTANCE;
        FluxHelper helper = FluxHelper.INSTANCE;
        MiscHelper miscHelper = MiscHelper.INSTANCE;
        ItemFormType itemFormType = ItemFormType.INSTANCE;
        for (IMaterial material : this.gritForm.getMaterials()) {
            oreLocation = miscHelper.getTagLocation("ores", material.getName());
            IItemInfo gritInfo = itemFormType.getMaterialFormInfo(this.gritForm, material);
            helper.registerWashingRecipe(new ResourceLocation("jaopca", "flux.ore_to_grit." + material.getName()), oreLocation, 1, gritInfo, 3, 0.0f, 200);
        }
        for (IMaterial material : moduleData.getMaterials()) {
            oreLocation = miscHelper.getTagLocation("ores", material.getName());
            ResourceLocation gritLocation = miscHelper.getTagLocation("grits", material.getName());
            ResourceLocation dustLocation = miscHelper.getTagLocation("dusts", material.getName());
            helper.registerGrindingRecipe(new ResourceLocation("jaopca", "flux.grit_to_dust." + material.getName()), gritLocation, 1, dustLocation, 1, 0.0f, 200);
            helper.registerGrindingRecipe(new ResourceLocation("jaopca", "flux.ore_to_dust." + material.getName()), oreLocation, 1, dustLocation, 2, 0.0f, 200);
        }
    }
}

