/*
 * Decompiled with CFR 0.152.
 */
package edivad.dimstorage.tile;

import edivad.dimstorage.api.Frequency;
import edivad.dimstorage.container.ContainerDimChest;
import edivad.dimstorage.manager.DimStorageManager;
import edivad.dimstorage.setup.Registration;
import edivad.dimstorage.storage.DimChestStorage;
import edivad.dimstorage.tile.TileFrequencyOwner;
import edivad.dimstorage.tools.Config;
import edivad.dimstorage.tools.utils.InventoryUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.AbstractFurnaceTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class TileEntityDimChest
extends TileFrequencyOwner
implements INamedContainerProvider {
    private static final float MIN_MOVABLE_POSITION = 0.0f;
    private static final float MAX_MOVABLE_POSITION = 0.5f;
    private static final float OPENING_SPEED = 0.05f;
    private int openCount;
    public float movablePartState = 0.0f;
    public int rotation;
    public static final int AREA = (Integer)Config.DIMCHEST_AREA.get();
    public boolean collect = false;
    private List<BlockPos> blockNeighbors;
    private LazyOptional<IItemHandler> itemHandler = LazyOptional.empty();

    public TileEntityDimChest() {
        super((TileEntityType)Registration.DIMCHEST_TILE.get());
        this.blockNeighbors = new ArrayList<BlockPos>();
        this.itemHandler.invalidate();
        this.itemHandler = LazyOptional.of(() -> new InvWrapper((IInventory)this.getStorage()));
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!(this.field_145850_b.field_72995_K || this.field_145850_b.func_82737_E() % 20L != 0L && this.openCount == this.getStorage().getNumOpen())) {
            this.openCount = this.getStorage().getNumOpen();
            this.field_145850_b.func_175641_c(this.func_174877_v(), this.func_195044_w().func_177230_c(), 1, this.openCount);
            this.field_145850_b.func_195593_d(this.field_174879_c, this.func_195044_w().func_177230_c());
            if (this.collect) {
                this.checkNeighbors();
            }
        }
        this.movablePartState = this.openCount > 0 ? (this.movablePartState < 0.5f ? (this.movablePartState += 0.05f) : 0.5f) : (this.movablePartState > 0.0f ? (this.movablePartState -= 0.05f) : 0.0f);
    }

    private List<BlockPos> getChunkNeighbors(int area) {
        int range = area / 2;
        return BlockPos.func_218281_b((BlockPos)this.func_174877_v().func_177982_a(-range, 0, -range), (BlockPos)this.func_174877_v().func_177982_a(range, 0, range)).map(BlockPos::func_185334_h).collect(Collectors.toList());
    }

    private void checkNeighbors() {
        if (this.blockNeighbors.isEmpty()) {
            this.blockNeighbors = this.getChunkNeighbors(AREA);
        }
        for (BlockPos pos : this.blockNeighbors) {
            TileEntity te;
            BlockState block = this.field_145850_b.func_180495_p(pos);
            if (!block.hasTileEntity() || (te = this.field_145850_b.func_175625_s(pos)) instanceof TileFrequencyOwner) continue;
            this.processInventory(te);
        }
    }

    private void processInventory(TileEntity te) {
        IItemHandler handler = this.getItemHandler(te);
        if (handler != null) {
            InvWrapper myInventory = new InvWrapper((IInventory)this.getStorage());
            int size = handler.getSlots();
            if (te instanceof AbstractFurnaceTileEntity) {
                --size;
            }
            for (int i = 0; i < size; ++i) {
                if (handler.getStackInSlot(i).func_190926_b()) continue;
                InventoryUtils.mergeItemStack(handler.getStackInSlot(i), 0, this.getStorage().func_70302_i_(), myInventory);
            }
        }
    }

    private IItemHandler getItemHandler(@Nonnull TileEntity tile) {
        IItemHandler handler = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.DOWN).orElse(null);
        if (handler == null) {
            if (tile instanceof ISidedInventory) {
                handler = new SidedInvWrapper((ISidedInventory)tile, Direction.DOWN);
            } else if (tile instanceof IInventory) {
                handler = new InvWrapper((IInventory)tile);
            }
        }
        return handler;
    }

    public int getComparatorInput() {
        return (Integer)this.itemHandler.map(ItemHandlerHelper::calcRedstoneFromInventory).orElse((Object)0);
    }

    @Override
    public void setFreq(Frequency frequency) {
        super.setFreq(frequency);
        this.itemHandler.invalidate();
        this.itemHandler = LazyOptional.of(() -> new InvWrapper((IInventory)this.getStorage()));
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.itemHandler.invalidate();
    }

    public void swapCollect() {
        this.collect = !this.collect;
        this.func_70296_d();
    }

    public boolean func_145842_c(int id, int type) {
        if (id == 1) {
            this.openCount = type;
            return true;
        }
        return false;
    }

    @Override
    public DimChestStorage getStorage() {
        return (DimChestStorage)DimStorageManager.instance(this.field_145850_b.field_72995_K).getStorage(this.frequency, "item");
    }

    public void onPlaced(LivingEntity entity) {
        this.rotation = (int)Math.floor((double)(entity.field_70177_z * 4.0f / 360.0f) + 2.5) & 3;
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        tag.func_74774_a("rot", (byte)this.rotation);
        tag.func_74757_a("collect", this.collect);
        return tag;
    }

    @Override
    public void func_145839_a(CompoundNBT tag) {
        super.func_145839_a(tag);
        this.rotation = tag.func_74771_c("rot") & 3;
        this.collect = tag.func_74767_n("collect");
    }

    @Override
    public ActionResultType activate(PlayerEntity player, World worldIn, BlockPos pos, Hand hand) {
        if (this.canAccess(player)) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)this, buf -> buf.func_179255_a(this.func_174877_v()).writeBoolean(false));
        } else {
            player.func_145747_a((ITextComponent)new StringTextComponent(TextFormatting.RED + "Access Denied!"));
        }
        return ActionResultType.SUCCESS;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
        if (!this.locked && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemHandler.cast();
        }
        return super.getCapability(capability, facing);
    }

    public final SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT root = new CompoundNBT();
        root.func_218657_a("Frequency", (INBT)this.frequency.serializeNBT());
        root.func_74757_a("locked", this.locked);
        root.func_74774_a("rot", (byte)this.rotation);
        root.func_74757_a("collect", this.collect);
        return new SUpdateTileEntityPacket(this.func_174877_v(), 1, root);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        CompoundNBT tag = pkt.func_148857_g();
        this.frequency.set(new Frequency(tag.func_74775_l("Frequency")));
        this.locked = tag.func_74767_n("locked");
        this.rotation = tag.func_74771_c("rot") & 3;
        this.collect = tag.func_74767_n("collect");
    }

    @Override
    public CompoundNBT func_189517_E_() {
        CompoundNBT tag = super.func_189517_E_();
        tag.func_74774_a("rot", (byte)this.rotation);
        tag.func_74757_a("collect", this.collect);
        return tag;
    }

    @Override
    public void handleUpdateTag(CompoundNBT tag) {
        super.handleUpdateTag(tag);
        this.rotation = tag.func_74771_c("rot") & 3;
        this.collect = tag.func_74767_n("collect");
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent(this.func_195044_w().func_177230_c().func_149739_a(), new Object[0]);
    }

    public Container createMenu(int id, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerDimChest(id, playerInventory, this, false);
    }
}

