/*
 * Decompiled with CFR 0.152.
 */
package edivad.dimstorage.manager;

import edivad.dimstorage.Main;
import edivad.dimstorage.api.AbstractDimStorage;
import edivad.dimstorage.api.DimStoragePlugin;
import edivad.dimstorage.api.Frequency;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.INBT;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class DimStorageManager {
    private static DimStorageManager serverManager;
    private static DimStorageManager clientManager;
    private static HashMap<String, DimStoragePlugin> plugins;
    private Map<String, AbstractDimStorage> storageMap;
    private Map<String, List<AbstractDimStorage>> storageList;
    private final boolean client;
    private File saveDir;
    private File[] saveFiles;
    private int saveTo;
    private List<AbstractDimStorage> dirtyStorage;
    private CompoundNBT saveTag;

    public DimStorageManager(boolean client) {
        this.client = client;
        this.storageMap = Collections.synchronizedMap(new HashMap());
        this.storageList = Collections.synchronizedMap(new HashMap());
        this.dirtyStorage = Collections.synchronizedList(new LinkedList());
        for (String key : plugins.keySet()) {
            this.storageList.put(key, new ArrayList());
        }
        if (this.isServer()) {
            this.load();
        }
    }

    public boolean isServer() {
        return !this.client;
    }

    private void sendClientInfo(PlayerEntity player) {
        for (Map.Entry<String, DimStoragePlugin> plugin : plugins.entrySet()) {
            plugin.getValue().sendClientInfo(player, this.storageList.get(plugin.getKey()));
        }
    }

    private void load() {
        this.saveDir = new File(Main.getServer().func_71218_a(DimensionType.field_223227_a_).func_217485_w().func_75765_b(), "DimStorage");
        try {
            if (!this.saveDir.exists()) {
                this.saveDir.mkdirs();
            }
            this.saveFiles = new File[]{new File(this.saveDir, "data1.dat"), new File(this.saveDir, "data2.dat"), new File(this.saveDir, "lock.dat")};
            if (this.saveFiles[2].exists() && this.saveFiles[2].length() > 0L) {
                FileInputStream fin = new FileInputStream(this.saveFiles[2]);
                this.saveTo = fin.read() ^ 1;
                fin.close();
                if (this.saveFiles[this.saveTo ^ 1].exists()) {
                    DataInputStream din = new DataInputStream(new FileInputStream(this.saveFiles[this.saveTo ^ 1]));
                    this.saveTag = CompressedStreamTools.func_74796_a((InputStream)din);
                    din.close();
                } else {
                    this.saveTag = new CompoundNBT();
                }
            } else {
                this.saveTag = new CompoundNBT();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("DimStorage was unable to read it's data, please delete the 'DimStorage' folder Here: %s and start the server again.", this.saveDir), e);
        }
    }

    private void save(boolean force) {
        if (!this.dirtyStorage.isEmpty() || force) {
            for (AbstractDimStorage inv : this.dirtyStorage) {
                this.saveTag.func_218657_a(inv.freq + ",type=" + inv.type(), (INBT)inv.saveToTag());
                inv.setClean();
            }
            this.dirtyStorage.clear();
            try {
                File saveFile = this.saveFiles[this.saveTo];
                if (!saveFile.exists()) {
                    saveFile.createNewFile();
                }
                DataOutputStream dout = new DataOutputStream(new FileOutputStream(saveFile));
                CompressedStreamTools.func_74799_a((CompoundNBT)this.saveTag, (OutputStream)dout);
                dout.close();
                FileOutputStream fout = new FileOutputStream(this.saveFiles[2]);
                fout.write(this.saveTo);
                fout.close();
                this.saveTo ^= 1;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void reloadManager(boolean client) {
        DimStorageManager newManager = new DimStorageManager(client);
        if (client) {
            clientManager = newManager;
        } else {
            serverManager = newManager;
        }
    }

    public static DimStorageManager instance(boolean client) {
        DimStorageManager manager;
        DimStorageManager dimStorageManager = manager = client ? clientManager : serverManager;
        if (manager == null) {
            DimStorageManager.reloadManager(client);
            manager = client ? clientManager : serverManager;
        }
        return manager;
    }

    public AbstractDimStorage getStorage(Frequency freq, String type) {
        String key = freq + ",type=" + type;
        AbstractDimStorage storage = this.storageMap.get(key);
        if (storage == null) {
            storage = plugins.get(type).createDimStorage(this, freq);
            if (!this.client && this.saveTag.func_74764_b(key)) {
                storage.loadFromTag(this.saveTag.func_74775_l(key));
            }
            this.storageMap.put(key, storage);
            this.storageList.get(type).add(storage);
        }
        return storage;
    }

    public static void registerPlugin(DimStoragePlugin plugin) {
        plugins.put(plugin.identifer(), plugin);
        if (serverManager != null) {
            DimStorageManager.serverManager.storageList.put(plugin.identifer(), new ArrayList());
        }
        if (clientManager != null) {
            DimStorageManager.clientManager.storageList.put(plugin.identifer(), new ArrayList());
        }
    }

    public void requestSave(AbstractDimStorage storage) {
        this.dirtyStorage.add(storage);
    }

    static {
        plugins = new HashMap();
    }

    public static class DimStorageSaveHandler {
        @SubscribeEvent
        public void onWorldLoad(WorldEvent.Load event) {
            if (event.getWorld().func_201672_e().field_72995_K) {
                DimStorageManager.reloadManager(true);
            }
        }

        @SubscribeEvent
        public void onWorldSave(WorldEvent.Save event) {
            if (!event.getWorld().func_201672_e().field_72995_K && DimStorageManager.instance(false) != null) {
                DimStorageManager.instance(false).save(false);
            }
        }

        @SubscribeEvent
        public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
            DimStorageManager.instance(false).sendClientInfo(event.getPlayer());
        }

        @SubscribeEvent
        public void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            DimStorageManager.instance(false).sendClientInfo(event.getPlayer());
        }
    }
}

