/*
 * Decompiled with CFR 0.152.
 */
package edivad.dimstorage.client.screen.pattern;

import edivad.dimstorage.client.screen.pattern.BaseScreen;
import edivad.dimstorage.tools.Config;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public class PanelScreen<T extends Container>
extends BaseScreen<T> {
    private static final int ANIMATION_SPEED = 10;
    private static final int SETTINGS_WIDTH = 80;
    private static final int SETTINGS_HEIGHT = 180;
    private static final int BUTTON_WIDTH = 20;
    private SettingsState state;
    private int animationState;
    protected boolean drawSettings;
    private boolean settingsButtonOver;
    private boolean allowConfig;
    private List<Widget> component;

    public PanelScreen(T container, PlayerInventory invPlayer, ITextComponent text, ResourceLocation background, boolean drawSettings) {
        super(container, invPlayer, text, background);
        this.drawSettings = drawSettings;
        this.settingsButtonOver = false;
        this.allowConfig = (Boolean)Config.DIMCHEST_ALLOWCONFIG.get();
        this.component = new ArrayList<Widget>();
        if (this.drawSettings) {
            this.animationState = 80;
            this.state = SettingsState.STATE_OPENED;
        } else {
            this.animationState = 0;
            this.state = SettingsState.STATE_CLOSED;
        }
    }

    @Override
    public void render(int mouseX, int mouseY, float partialTicks) {
        super.render(mouseX, mouseY, partialTicks);
        if (this.state == SettingsState.STATE_OPENNING) {
            this.animationState += 10;
            if (this.animationState >= 80) {
                this.animationState = 80;
                this.state = SettingsState.STATE_OPENED;
                this.drawSettings(true);
            }
        } else if (this.state == SettingsState.STATE_CLOSING) {
            this.drawSettings(false);
            this.animationState -= 10;
            if (this.animationState <= 0) {
                this.animationState = 0;
                this.state = SettingsState.STATE_CLOSED;
            }
        }
    }

    private int getButtonX() {
        return this.field_147003_i + this.field_146999_f;
    }

    private int getButtonY() {
        return this.field_147009_r + 16;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int clickedButton) {
        super.mouseClicked(mouseX, mouseY, clickedButton);
        if (this.allowConfig && mouseX >= (double)this.getButtonX() && mouseX <= (double)(this.getButtonX() + 20) && mouseY >= (double)this.getButtonY() && mouseY <= (double)(this.getButtonY() + 20)) {
            if (this.state == SettingsState.STATE_CLOSED) {
                this.state = SettingsState.STATE_OPENNING;
            } else if (this.state == SettingsState.STATE_OPENED) {
                this.state = SettingsState.STATE_CLOSING;
            }
            return true;
        }
        return false;
    }

    public void func_212927_b(double mouseX, double mouseY) {
        super.func_212927_b(mouseX, mouseY);
        this.settingsButtonOver = false;
        if (mouseX >= (double)this.getButtonX() && mouseX <= (double)(this.getButtonX() + 20) && mouseY >= (double)this.getButtonY() && mouseY <= (double)(this.getButtonY() + 20)) {
            this.settingsButtonOver = true;
        }
    }

    @Override
    protected void func_146976_a(float f, int i, int j) {
        super.func_146976_a(f, i, j);
        int settingsX = this.field_147003_i + (this.field_146999_f - 80);
        if (this.allowConfig) {
            this.blit(settingsX + this.animationState, this.field_147009_r + 36, this.field_146999_f, 36, 80, this.field_147000_g);
        }
        this.blit(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g + 2);
        this.blit(this.getButtonX(), this.getButtonY(), this.field_146999_f, 16, 20, 20);
        if (this.state == SettingsState.STATE_CLOSED || this.state == SettingsState.STATE_OPENNING) {
            if (this.settingsButtonOver) {
                this.blit(this.getButtonX() + 6, this.getButtonY() - 3, this.field_146999_f + 28, 16, 8, 20);
            } else {
                this.blit(this.getButtonX() + 6, this.getButtonY() - 3, this.field_146999_f + 20, 16, 8, 20);
            }
        } else if (this.state == SettingsState.STATE_OPENED || this.state == SettingsState.STATE_CLOSING) {
            if (this.settingsButtonOver) {
                this.blit(this.getButtonX() + 4, this.getButtonY() - 3, this.field_146999_f + 44, 16, 8, 20);
            } else {
                this.blit(this.getButtonX() + 4, this.getButtonY() - 3, this.field_146999_f + 36, 16, 8, 20);
            }
        }
    }

    public List<Rectangle2d> getAreas() {
        ArrayList<Rectangle2d> extraAreas = new ArrayList<Rectangle2d>();
        extraAreas.add(new Rectangle2d(this.field_147003_i + this.field_146999_f, this.getButtonY(), 20, 20));
        extraAreas.add(new Rectangle2d(this.field_147003_i + this.field_146999_f, this.getButtonY() + 20, this.animationState, 180));
        return extraAreas;
    }

    protected void clearComponent() {
        for (Widget widget : this.component) {
            if (!(widget instanceof Button)) continue;
            this.buttons.clear();
            break;
        }
        this.component.clear();
    }

    protected void addComponent(Widget widget) {
        this.component.add(widget);
        if (widget instanceof Button) {
            this.addButton((Widget)((Button)widget));
        } else if (widget instanceof TextFieldWidget) {
            this.children.add((TextFieldWidget)widget);
        }
    }

    protected void drawSettings(boolean draw) {
        this.drawSettings = draw;
        for (Widget widget : this.component) {
            widget.visible = draw;
        }
    }

    private static enum SettingsState {
        STATE_CLOSED,
        STATE_OPENNING,
        STATE_OPENED,
        STATE_CLOSING;

    }
}

