/*
 * Decompiled with CFR 0.152.
 */
package com.thevortex.potionsmaster.render.util;

import com.thevortex.potionsmaster.render.util.SimpleStructureData;
import com.thevortex.potionsmaster.render.util.StructureData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.Vec3i;

public class StructureStore {
    public static final List<SimpleStructureData> DEFAULT_STRUCTURES = new ArrayList<SimpleStructureData>();
    private HashMap<UUID, StructureData> store = new HashMap();
    private HashMap<String, UUID> storeReference = new HashMap();

    public void put(StructureData data) {
        if (this.storeReference.containsKey(data.getStructureName())) {
            return;
        }
        UUID uniqueId = UUID.randomUUID();
        this.store.put(uniqueId, data);
        this.storeReference.put(data.getStructureName(), uniqueId);
    }

    public HashMap<UUID, StructureData> getStore() {
        return this.store;
    }

    public void setStore(ArrayList<StructureData> store) {
        this.store.clear();
        this.storeReference.clear();
        store.forEach(this::put);
    }

    public StructureDataWithUUID getStoreByReference(String name) {
        UUID uniqueId = this.storeReference.get(name);
        if (uniqueId == null) {
            return null;
        }
        StructureData structureData = this.store.get(uniqueId);
        if (structureData == null) {
            return null;
        }
        return new StructureDataWithUUID(structureData, uniqueId);
    }

    public void toggleDrawing(StructureData data) {
        UUID uniqueId = this.storeReference.get(data.getStructureName());
        if (uniqueId == null) {
            return;
        }
        StructureData structureData = this.store.get(uniqueId);
        if (structureData == null) {
            return;
        }
        structureData.setDrawing(!structureData.isDrawing());
    }

    public static ArrayList<StructureData> getFromSimpleStructureList(List<SimpleStructureData> simpleList) {
        ArrayList<StructureData> structureData = new ArrayList<StructureData>();
        for (SimpleStructureData e : simpleList) {
            if (e == null) continue;
            structureData.add(new StructureData(e.getName(), e.getStructureName(), e.getColor(), new ItemStack((IItemProvider)Items.field_190931_a, 1), e.isDrawing(), e.getOrder()));
        }
        return structureData;
    }

    public static final class StructureDataWithUUID {
        StructureData structureData;
        UUID uuid;

        public StructureDataWithUUID(StructureData structureData, UUID uuid) {
            this.structureData = structureData;
            this.uuid = uuid;
        }

        public StructureData getStructureData() {
            return this.structureData;
        }

        public UUID getUuid() {
            return this.uuid;
        }

        public Vec3i getStructureInfo() {
            return null;
        }
    }
}

