/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.client.screen.inventory;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import owmii.lib.client.screen.EnergyProviderScreen;
import owmii.lib.client.screen.widget.Gauge;
import owmii.lib.client.util.Draw;
import owmii.lib.inventory.EnergyContainerBase;
import owmii.lib.util.Safe;
import owmii.powah.api.PowahAPI;
import owmii.powah.block.magmator.MagmatorTile;
import owmii.powah.inventory.MagmatorContainer;

@OnlyIn(value=Dist.CLIENT)
public class MagmatorScreen
extends EnergyProviderScreen<MagmatorTile, MagmatorContainer> {
    private static final ResourceLocation GUI_MACHINE = new ResourceLocation("lollipop", "textures/gui/container/blank_right_gauge.png");
    private Gauge buffer = GAUGE;

    public MagmatorScreen(MagmatorContainer container, PlayerInventory playerInventory, ITextComponent name) {
        super((EnergyContainerBase)container, playerInventory, name);
    }

    public void init(Minecraft mc, int w, int h) {
        super.init(mc, w, h);
        this.buffer = this.gauge(this.x + 82, this.y + 27, 11, 18, 13, 0, GUI_BUFFER).setBG(this.x + 81, this.y + 26, 13, 20, 0, 0);
    }

    protected void configButtons(int x, int y) {
        super.configButtons(x - 19, y);
    }

    protected void refreshScreen() {
        super.refreshScreen();
        boolean bl = this.buffer.visible = !this.configVisible;
        if (this.buffer.isHovered()) {
            int percent = Safe.integer((long)(((MagmatorTile)this.te).getBuffer() > 0L ? 100L * ((MagmatorTile)this.te).getNextBuff() / ((MagmatorTile)this.te).getBuffer() : 0L));
            this.buffer.clearToolTip().tooltip("info.lollipop.buffer", TextFormatting.GRAY, new Object[]{"" + TextFormatting.DARK_GRAY + percent + "%"});
        }
    }

    protected void drawBackground(float partialTicks, int mouseX, int mouseY) {
        FluidStack fluidStack;
        FluidAttributes fa;
        ResourceLocation still;
        super.drawBackground(partialTicks, mouseX, mouseY);
        this.buffer.render(((MagmatorTile)this.te).getBuffer(), ((MagmatorTile)this.te).getNextBuff(), mouseX, mouseY);
        FluidTank tank = ((MagmatorTile)this.te).getTank();
        if (!tank.isEmpty() && (still = (fa = (fluidStack = tank.getFluid()).getFluid().getAttributes()).getStillTexture(fluidStack)) != null) {
            int color = fa.getColor(fluidStack);
            float red = (float)(color >> 16 & 0xFF) / 255.0f;
            float green = (float)(color >> 8 & 0xFF) / 255.0f;
            float blue = (float)(color & 0xFF) / 255.0f;
            RenderSystem.color3f((float)red, (float)green, (float)blue);
            TextureAtlasSprite sprite = (TextureAtlasSprite)this.mc.func_228015_a_(PlayerContainer.field_226615_c_).apply(still);
            this.bindTexture(PlayerContainer.field_226615_c_);
            Draw.gaugeV((TextureAtlasSprite)sprite, (int)(this.x + 162), (int)(this.y + 4), (int)10, (int)64, (int)tank.getCapacity(), (int)tank.getFluidAmount());
            RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    protected void func_191948_b(int mouseX, int mouseY) {
        if (!this.buffer.renderToolTip(mouseX, mouseY)) {
            super.func_191948_b(mouseX, mouseY);
        }
        FluidTank tank = ((MagmatorTile)this.te).getTank();
        if (this.isMouseOver(mouseX - 161, mouseY - 3, 12, 66)) {
            ArrayList<String> list = new ArrayList<String>();
            if (!tank.isEmpty()) {
                list.add(TextFormatting.GRAY + I18n.func_135052_a((String)"info.lollipop.fluid", (Object[])new Object[]{TextFormatting.GOLD + tank.getFluid().getDisplayName().getString()}));
                list.add(TextFormatting.GRAY + I18n.func_135052_a((String)"info.lollipop.fluid.stored", (Object[])new Object[]{"" + TextFormatting.DARK_GRAY + tank.getFluidAmount(), tank.getCapacity()}));
                list.add(TextFormatting.GRAY + I18n.func_135052_a((String)"info.lollipop.energy.per.mb", (Object[])new Object[]{"" + TextFormatting.DARK_GRAY + PowahAPI.getMagmaticFluidHeat(tank.getFluid().getFluid()), 100}));
            } else {
                list.add(TextFormatting.GRAY + I18n.func_135052_a((String)"info.lollipop.fluid", (Object[])new Object[]{TextFormatting.DARK_GRAY + "----"}));
            }
            this.renderTooltip(list, mouseX, mouseY);
        }
    }

    protected ResourceLocation getMachineBackGround() {
        return GUI_MACHINE;
    }

    protected ResourceLocation getConfigBackGround() {
        return GUI_MACHINE;
    }
}

