/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.client.model;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import owmii.lib.client.model.AbstractModel;
import owmii.lib.energy.Energy;
import owmii.lib.energy.SideConfig;
import owmii.powah.block.cable.EnergyCableTile;
import owmii.powah.client.render.tile.EnergyCableRenderer;

public class EnergyCableModel
extends AbstractModel<EnergyCableTile, EnergyCableRenderer> {
    private final ModelRenderer north;
    private final ModelRenderer northPlate;
    private final ModelRenderer south;
    private final ModelRenderer southPlate;
    private final ModelRenderer west;
    private final ModelRenderer westPlate;
    private final ModelRenderer east;
    private final ModelRenderer eastPlate;
    private final ModelRenderer down;
    private final ModelRenderer upPlate;
    private final ModelRenderer up;
    private final ModelRenderer downPlate;
    private static final Map<SideConfig.Type, ResourceLocation> TEXTURES = new HashMap<SideConfig.Type, ResourceLocation>();

    public EnergyCableModel() {
        super(RenderType::func_228634_a_);
        this.field_78090_t = 64;
        this.field_78089_u = 32;
        this.north = new ModelRenderer((Model)this, 0, 10);
        this.north.func_228300_a_(-1.5f, -1.5f, -7.75f, 3.0f, 3.0f, 6.0f);
        this.north.func_78793_a(0.0f, 14.0f, 0.0f);
        this.north.func_78787_b(64, 32);
        this.north.field_78809_i = true;
        this.setRotation(this.north, 0.0f, 0.0f, 0.0f);
        this.northPlate = new ModelRenderer((Model)this, 0, 20);
        this.northPlate.func_228300_a_(-2.5f, -2.5f, -8.2f, 5.0f, 5.0f, 1.0f);
        this.northPlate.func_78793_a(0.0f, 14.0f, 0.0f);
        this.northPlate.func_78787_b(64, 32);
        this.northPlate.field_78809_i = true;
        this.setRotation(this.northPlate, 0.0f, 0.0f, 0.0f);
        this.south = new ModelRenderer((Model)this, 0, 0);
        this.south.func_228300_a_(-1.5f, -1.5f, 1.75f, 3.0f, 3.0f, 6.0f);
        this.south.func_78793_a(0.0f, 14.0f, 0.0f);
        this.south.func_78787_b(64, 32);
        this.south.field_78809_i = true;
        this.setRotation(this.south, 0.0f, 0.0f, 0.0f);
        this.southPlate = new ModelRenderer((Model)this, 0, 20);
        this.southPlate.func_228300_a_(-2.5f, -2.5f, 7.2f, 5.0f, 5.0f, 1.0f);
        this.southPlate.func_78793_a(0.0f, 14.0f, 0.0f);
        this.southPlate.func_78787_b(64, 32);
        this.southPlate.field_78809_i = true;
        this.setRotation(this.southPlate, 0.0f, 0.0f, 0.0f);
        this.west = new ModelRenderer((Model)this, 19, 0);
        this.west.func_228300_a_(-7.75f, -1.5f, -1.5f, 6.0f, 3.0f, 3.0f);
        this.west.func_78793_a(0.0f, 14.0f, 0.0f);
        this.west.func_78787_b(64, 32);
        this.west.field_78809_i = true;
        this.setRotation(this.west, 0.0f, 0.0f, 0.0f);
        this.westPlate = new ModelRenderer((Model)this, 13, 20);
        this.westPlate.func_228300_a_(-8.2f, -2.5f, -2.5f, 1.0f, 5.0f, 5.0f);
        this.westPlate.func_78793_a(0.0f, 14.0f, 0.0f);
        this.westPlate.func_78787_b(64, 32);
        this.westPlate.field_78809_i = true;
        this.setRotation(this.westPlate, 0.0f, 0.0f, 0.0f);
        this.east = new ModelRenderer((Model)this, 19, 7);
        this.east.func_228300_a_(1.75f, -1.5f, -1.5f, 6.0f, 3.0f, 3.0f);
        this.east.func_78793_a(0.0f, 14.0f, 0.0f);
        this.east.func_78787_b(64, 32);
        this.east.field_78809_i = true;
        this.setRotation(this.east, 0.0f, 0.0f, 0.0f);
        this.eastPlate = new ModelRenderer((Model)this, 13, 20);
        this.eastPlate.func_228300_a_(7.2f, -2.5f, -2.5f, 1.0f, 5.0f, 5.0f);
        this.eastPlate.func_78793_a(0.0f, 14.0f, 0.0f);
        this.eastPlate.func_78787_b(64, 32);
        this.eastPlate.field_78809_i = true;
        this.setRotation(this.eastPlate, 0.0f, 0.0f, 0.0f);
        this.down = new ModelRenderer((Model)this, 38, 0);
        this.down.func_228300_a_(-1.5f, -7.75f, -1.5f, 3.0f, 6.0f, 3.0f);
        this.down.func_78793_a(0.0f, 14.0f, 0.0f);
        this.down.func_78787_b(64, 32);
        this.down.field_78809_i = true;
        this.setRotation(this.down, 0.0f, 0.0f, 0.0f);
        this.upPlate = new ModelRenderer((Model)this, 26, 20);
        this.upPlate.func_228300_a_(-2.5f, 7.2f, -2.5f, 5.0f, 1.0f, 5.0f);
        this.upPlate.func_78793_a(0.0f, 14.0f, 0.0f);
        this.upPlate.func_78787_b(64, 32);
        this.upPlate.field_78809_i = true;
        this.setRotation(this.upPlate, 0.0f, 0.0f, 0.0f);
        this.up = new ModelRenderer((Model)this, 38, 10);
        this.up.func_228300_a_(-1.5f, 1.75f, -1.5f, 3.0f, 6.0f, 3.0f);
        this.up.func_78793_a(0.0f, 14.0f, 0.0f);
        this.up.func_78787_b(64, 32);
        this.up.field_78809_i = true;
        this.setRotation(this.up, 0.0f, 0.0f, 0.0f);
        this.downPlate = new ModelRenderer((Model)this, 26, 20);
        this.downPlate.func_228300_a_(-2.5f, -8.2f, -2.5f, 5.0f, 1.0f, 5.0f);
        this.downPlate.func_78793_a(0.0f, 14.0f, 0.0f);
        this.downPlate.func_78787_b(64, 32);
        this.downPlate.field_78809_i = true;
        this.setRotation(this.downPlate, 0.0f, 0.0f, 0.0f);
    }

    public void render(EnergyCableTile te, EnergyCableRenderer renderer, MatrixStack matrix, IRenderTypeBuffer rtb, int light, int ov) {
        IVertexBuilder buffer;
        SideConfig.Type type;
        if (te.func_145831_w() == null) {
            return;
        }
        Direction[] flags = new Direction[6];
        for (Direction side : te.energySides) {
            BlockPos pos = te.func_174877_v().func_177972_a(side);
            TileEntity tile = te.func_145831_w().func_175625_s(pos);
            SideConfig.Type config = te.getSideConfig().getType(side);
            if (tile instanceof EnergyCableTile || !Energy.isPresent((TileEntity)tile, (Direction)side) || !config.isOut() && !config.isIn()) continue;
            flags[side.func_176745_a()] = side;
        }
        if (flags[0] != null && !(type = te.getSideConfig().getType(flags[0])).isOff()) {
            buffer = rtb.getBuffer(this.func_228282_a_(TEXTURES.get(type)));
            this.up.func_228308_a_(matrix, buffer, light, ov);
            this.upPlate.func_228308_a_(matrix, buffer, light, ov);
        }
        if (flags[1] != null && !(type = te.getSideConfig().getType(flags[1])).isOff()) {
            buffer = rtb.getBuffer(this.func_228282_a_(TEXTURES.get(type)));
            this.down.func_228308_a_(matrix, buffer, light, ov);
            this.downPlate.func_228308_a_(matrix, buffer, light, ov);
        }
        if (flags[2] != null && !(type = te.getSideConfig().getType(flags[2])).isOff()) {
            buffer = rtb.getBuffer(this.func_228282_a_(TEXTURES.get(type)));
            this.south.func_228308_a_(matrix, buffer, light, ov);
            this.southPlate.func_228308_a_(matrix, buffer, light, ov);
        }
        if (flags[3] != null && !(type = te.getSideConfig().getType(flags[3])).isOff()) {
            buffer = rtb.getBuffer(this.func_228282_a_(TEXTURES.get(type)));
            this.north.func_228308_a_(matrix, buffer, light, ov);
            this.northPlate.func_228308_a_(matrix, buffer, light, ov);
        }
        if (flags[4] != null && !(type = te.getSideConfig().getType(flags[4])).isOff()) {
            buffer = rtb.getBuffer(this.func_228282_a_(TEXTURES.get(type)));
            this.west.func_228308_a_(matrix, buffer, light, ov);
            this.westPlate.func_228308_a_(matrix, buffer, light, ov);
        }
        if (flags[5] != null && !(type = te.getSideConfig().getType(flags[5])).isOff()) {
            buffer = rtb.getBuffer(this.func_228282_a_(TEXTURES.get(type)));
            this.east.func_228308_a_(matrix, buffer, light, ov);
            this.eastPlate.func_228308_a_(matrix, buffer, light, ov);
        }
    }

    static {
        TEXTURES.put(SideConfig.Type.ALL, new ResourceLocation("powah", "textures/model/tile/energy_cable_all.png"));
        TEXTURES.put(SideConfig.Type.OUT, new ResourceLocation("powah", "textures/model/tile/energy_cable_out.png"));
        TEXTURES.put(SideConfig.Type.IN, new ResourceLocation("powah", "textures/model/tile/energy_cable_in.png"));
    }
}

