/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.thermo;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import owmii.lib.block.AbstractEnergyProviderBlock;
import owmii.lib.block.TileBase;
import owmii.lib.config.IEnergyProviderConfig;
import owmii.lib.inventory.ContainerBase;
import owmii.lib.util.IVariant;
import owmii.powah.block.Tier;
import owmii.powah.block.thermo.ThermoGenTile;
import owmii.powah.config.Configs;
import owmii.powah.inventory.IContainers;
import owmii.powah.inventory.ThermoGenContainer;

public class ThermoGenBlock
extends AbstractEnergyProviderBlock<Tier>
implements IWaterLoggable {
    public static final VoxelShape SHAPE = VoxelShapes.func_197878_a((VoxelShape)ThermoGenBlock.func_208617_a((double)2.0, (double)1.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0), (VoxelShape)ThermoGenBlock.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0), (IBooleanFunction)IBooleanFunction.field_223244_o_);

    public ThermoGenBlock(Block.Properties properties, Tier variant) {
        super(properties, (IVariant)variant);
    }

    public IEnergyProviderConfig<Tier> getEnergyConfig() {
        return Configs.THERMO;
    }

    public int stackSize() {
        return 1;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new ThermoGenTile((Tier)this.variant);
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult blockRayTraceResult) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof ThermoGenTile) {
            ThermoGenTile genTile = (ThermoGenTile)tile;
            boolean result = FluidUtil.interactWithFluidHandler((PlayerEntity)player, (Hand)hand, (IFluidHandler)genTile.tank);
            if (result) {
                genTile.markDirtyAndSync();
                return ActionResultType.SUCCESS;
            }
        }
        return super.func_225533_a_(state, world, pos, player, hand, blockRayTraceResult);
    }

    @Nullable
    public ContainerBase getContainer(int id, PlayerInventory playerInventory, TileBase te, BlockRayTraceResult result) {
        if (te instanceof ThermoGenTile) {
            return new ThermoGenContainer(IContainers.THERMO_GEN, id, playerInventory, (ThermoGenTile)te);
        }
        return null;
    }
}

