/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.solarpanel;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import owmii.lib.block.TileBase;
import owmii.lib.util.IVariant;
import owmii.lib.util.Misc;
import owmii.lib.util.Time;
import owmii.powah.block.ITiles;
import owmii.powah.block.Tier;
import owmii.powah.block.solarpanel.SolarPanelBlock;
import owmii.powah.item.IItems;

public class SolarPanelTile
extends TileBase.EnergyProvider<Tier, SolarPanelBlock> {
    private boolean canSeeSunLight;
    private boolean hasLensOfEnder;

    public SolarPanelTile(Tier variant) {
        super(ITiles.SOLAR_PANEL, (IVariant)variant);
    }

    public SolarPanelTile() {
        this(Tier.STARTER);
    }

    public void readSync(CompoundNBT compound) {
        super.readSync(compound);
        this.canSeeSunLight = compound.func_74767_n("CanSeeSunLight");
        this.hasLensOfEnder = compound.func_74767_n("HasLensOfEnder");
    }

    public CompoundNBT writeSync(CompoundNBT compound) {
        compound.func_74757_a("CanSeeSunLight", this.canSeeSunLight);
        compound.func_74757_a("HasLensOfEnder", this.hasLensOfEnder);
        return super.writeSync(compound);
    }

    protected boolean postTicks(World world) {
        if (this.isRemote()) {
            return false;
        }
        boolean flag = false;
        if (this.doWorkingTicks(world)) {
            if (!this.hasLensOfEnder && (!Time.isDay((World)world) && this.canSeeSunLight || (long)this.ticks % 40L == 0L)) {
                this.canSeeSunLight = Time.isDay((World)world) && Misc.canBlockSeeSky((World)world, (BlockPos)this.field_174879_c);
                this.markDirtyAndSync();
            }
            if (!this.energy.isFull() && (this.hasLensOfEnder && Time.isDay((World)world) || this.canSeeSunLight)) {
                this.energy.produce(this.defaultGeneration());
                flag = true;
            }
        }
        return super.postTicks(world) || flag;
    }

    public void onRemoved(World world, BlockState state, BlockState newState, boolean isMoving) {
        super.onRemoved(world, state, newState, isMoving);
        if (state.func_177230_c() != newState.func_177230_c() && this.hasLensOfEnder) {
            Block.func_180635_a((World)world, (BlockPos)this.field_174879_c, (ItemStack)new ItemStack((IItemProvider)IItems.LENS_OF_ENDER));
        }
    }

    public int getChargingSlots() {
        return 1;
    }

    public boolean canSeeSunLight() {
        return this.canSeeSunLight;
    }

    public boolean keepEnergy() {
        return true;
    }

    public boolean isEnergyPresent(@Nullable Direction side) {
        return Direction.DOWN.equals((Object)side);
    }

    public boolean hasLensOfEnder() {
        return this.hasLensOfEnder;
    }

    public void setHasLensOfEnder(boolean hasLensOfEnder) {
        this.hasLensOfEnder = hasLensOfEnder;
        this.markDirtyAndSync();
    }
}

