/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.endercell;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import owmii.lib.block.AbstractEnergyBlock;
import owmii.lib.block.TileBase;
import owmii.lib.config.IEnergyConfig;
import owmii.lib.energy.Energy;
import owmii.lib.inventory.ContainerBase;
import owmii.lib.item.BlockItemBase;
import owmii.lib.util.IVariant;
import owmii.lib.util.Stack;
import owmii.powah.block.Tier;
import owmii.powah.block.endercell.EnderCellTile;
import owmii.powah.config.Configs;
import owmii.powah.config.EnderCellConfig;
import owmii.powah.inventory.EnderCellContainer;
import owmii.powah.inventory.IContainers;
import owmii.powah.item.EnderCellItem;

public class EnderCellBlock
extends AbstractEnergyBlock<Tier> {
    public EnderCellBlock(Block.Properties properties, Tier variant) {
        super(properties, (IVariant)variant);
    }

    public BlockItemBase getBlockItem(Item.Properties properties, @Nullable ItemGroup group) {
        return new EnderCellItem(this, properties, group);
    }

    public IEnergyConfig<Tier> getEnergyConfig() {
        return Configs.ENDER_CELL;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new EnderCellTile((Tier)this.variant);
    }

    @Nullable
    public ContainerBase getContainer(int id, PlayerInventory playerInventory, TileBase te, BlockRayTraceResult result) {
        if (te instanceof EnderCellTile) {
            return new EnderCellContainer(IContainers.ENDER_CELL, id, playerInventory, (EnderCellTile)te);
        }
        return null;
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        EnderCellTile tile;
        super.func_180633_a(worldIn, pos, state, placer, stack);
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof EnderCellTile && (tile = (EnderCellTile)tileentity).getOwner() == null && placer instanceof ServerPlayerEntity) {
            tile.setOwner(((ServerPlayerEntity)placer).func_146103_bH());
        }
    }

    public void additionalEnergyInfo(ItemStack stack, Energy.Item energy, List<ITextComponent> tooltip) {
        tooltip.add(new TranslationTextComponent("info.lollipop.max.channels", new Object[]{"" + TextFormatting.DARK_GRAY + this.getTotalChannels()}).func_211708_a(TextFormatting.GRAY));
        tooltip.add((ITextComponent)new StringTextComponent(""));
        CompoundNBT nbt = Stack.getTagOrEmpty((ItemStack)stack).func_74775_l("lollipopTileStorableNBT");
        tooltip.add(new TranslationTextComponent("info.powah.channel", new Object[]{"" + TextFormatting.DARK_AQUA + (nbt.func_74762_e("ActiveChannel") + 1)}).func_211708_a(TextFormatting.DARK_GRAY));
    }

    public int getTotalChannels() {
        return ((EnderCellConfig)this.getEnergyConfig()).getChannels((Tier)this.variant);
    }
}

