/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.cable;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SixWayBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.DiggingParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import owmii.lib.api.energy.INoTileEnergy;
import owmii.lib.block.AbstractEnergyBlock;
import owmii.lib.block.TileBase;
import owmii.lib.config.IEnergyConfig;
import owmii.lib.energy.Energy;
import owmii.lib.inventory.ContainerBase;
import owmii.lib.util.IVariant;
import owmii.powah.block.Tier;
import owmii.powah.block.cable.EnergyCableTile;
import owmii.powah.config.Configs;
import owmii.powah.inventory.EnergyCableContainer;
import owmii.powah.inventory.IContainers;

public class EnergyCableBlock
extends AbstractEnergyBlock<Tier>
implements IWaterLoggable,
INoTileEnergy {
    public static final BooleanProperty NORTH = SixWayBlock.field_196488_a;
    public static final BooleanProperty EAST = SixWayBlock.field_196490_b;
    public static final BooleanProperty SOUTH = SixWayBlock.field_196492_c;
    public static final BooleanProperty WEST = SixWayBlock.field_196495_y;
    public static final BooleanProperty UP = SixWayBlock.field_196496_z;
    public static final BooleanProperty DOWN = SixWayBlock.field_196489_A;
    public static final BooleanProperty TILE = BooleanProperty.func_177716_a((String)"tile");
    private static final VoxelShape CABLE = EnergyCableBlock.func_208617_a((double)6.25, (double)6.25, (double)6.25, (double)9.75, (double)9.75, (double)9.75);
    private static final VoxelShape[] MULTIPART = new VoxelShape[]{EnergyCableBlock.func_208617_a((double)6.5, (double)6.5, (double)0.0, (double)9.5, (double)9.5, (double)7.0), EnergyCableBlock.func_208617_a((double)9.5, (double)6.5, (double)6.5, (double)16.0, (double)9.5, (double)9.5), EnergyCableBlock.func_208617_a((double)6.5, (double)6.5, (double)9.5, (double)9.5, (double)9.5, (double)16.0), EnergyCableBlock.func_208617_a((double)0.0, (double)6.5, (double)6.5, (double)6.5, (double)9.5, (double)9.5), EnergyCableBlock.func_208617_a((double)6.5, (double)9.5, (double)6.5, (double)9.5, (double)16.0, (double)9.5), EnergyCableBlock.func_208617_a((double)6.5, (double)0.0, (double)6.5, (double)9.5, (double)7.0, (double)9.5)};
    static final Map<BlockPos, Set<BlockPos>> CACHE = new HashMap<BlockPos, Set<BlockPos>>();

    public EnergyCableBlock(Block.Properties properties, Tier variant) {
        super(properties, (IVariant)variant);
        this.setStateProps(state -> {
            BlockState cfr_ignored_0 = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a((IProperty)NORTH, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)EAST, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)WEST, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)UP, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)DOWN, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)TILE, (Comparable)Boolean.valueOf(false));
        });
    }

    public IEnergyConfig<Tier> getEnergyConfig() {
        return Configs.ENERGY_CABLE;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        VoxelShape voxelShape = CABLE;
        if (((Boolean)state.func_177229_b((IProperty)NORTH)).booleanValue() || this.canConnectEnergy(world, pos, Direction.NORTH)) {
            voxelShape = VoxelShapes.func_197872_a((VoxelShape)voxelShape, (VoxelShape)MULTIPART[0]);
        }
        if (((Boolean)state.func_177229_b((IProperty)EAST)).booleanValue() || this.canConnectEnergy(world, pos, Direction.EAST)) {
            voxelShape = VoxelShapes.func_197872_a((VoxelShape)voxelShape, (VoxelShape)MULTIPART[1]);
        }
        if (((Boolean)state.func_177229_b((IProperty)SOUTH)).booleanValue() || this.canConnectEnergy(world, pos, Direction.SOUTH)) {
            voxelShape = VoxelShapes.func_197872_a((VoxelShape)voxelShape, (VoxelShape)MULTIPART[2]);
        }
        if (((Boolean)state.func_177229_b((IProperty)WEST)).booleanValue() || this.canConnectEnergy(world, pos, Direction.WEST)) {
            voxelShape = VoxelShapes.func_197872_a((VoxelShape)voxelShape, (VoxelShape)MULTIPART[3]);
        }
        if (((Boolean)state.func_177229_b((IProperty)UP)).booleanValue() || this.canConnectEnergy(world, pos, Direction.UP)) {
            voxelShape = VoxelShapes.func_197872_a((VoxelShape)voxelShape, (VoxelShape)MULTIPART[4]);
        }
        if (((Boolean)state.func_177229_b((IProperty)DOWN)).booleanValue() || this.canConnectEnergy(world, pos, Direction.DOWN)) {
            voxelShape = VoxelShapes.func_197872_a((VoxelShape)voxelShape, (VoxelShape)MULTIPART[5]);
        }
        return voxelShape;
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult result) {
        Optional<Direction> hitSide = EnergyCableBlock.getHitSide(result.func_216347_e(), pos);
        if (hitSide.isPresent() && !this.canConnectEnergy((IBlockReader)world, pos, hitSide.get())) {
            return ActionResultType.FAIL;
        }
        return super.func_225533_a_(state, world, pos, player, hand, result);
    }

    @Nullable
    public <T extends TileBase> ContainerBase getContainer(int id, PlayerInventory inventory, TileBase te, BlockRayTraceResult result) {
        if (te instanceof EnergyCableTile) {
            return new EnergyCableContainer(IContainers.ENERGY_CABLE, id, inventory, (EnergyCableTile)te);
        }
        return null;
    }

    protected void additionalGuiData(PacketBuffer buffer, BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult result) {
        EnergyCableBlock.getHitSide(result.func_216347_e(), pos).ifPresent(side -> buffer.writeInt(side.func_176745_a()));
        super.additionalGuiData(buffer, state, world, pos, player, hand, result);
    }

    public boolean hasTileEntity(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)TILE);
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new EnergyCableTile((Tier)this.variant);
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        TileEntity tileEntity = world.func_175625_s(currentPos);
        if (tileEntity instanceof EnergyCableTile) {
            EnergyCableTile cable = (EnergyCableTile)tileEntity;
            cable.energySides.clear();
            for (Direction direction : Direction.values()) {
                if (!this.canConnectEnergy((IBlockReader)world, currentPos, direction)) continue;
                cable.energySides.add(direction);
            }
            cable.markDirtyAndSync();
        }
        return this.createCableState(world, currentPos);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return this.createCableState((IWorld)context.func_195991_k(), context.func_195995_a());
    }

    private BlockState createCableState(IWorld world, BlockPos pos) {
        BlockState state = this.func_176223_P();
        boolean[] north = this.canAttach(state, world, pos, Direction.NORTH);
        boolean[] south = this.canAttach(state, world, pos, Direction.SOUTH);
        boolean[] west = this.canAttach(state, world, pos, Direction.WEST);
        boolean[] east = this.canAttach(state, world, pos, Direction.EAST);
        boolean[] up = this.canAttach(state, world, pos, Direction.UP);
        boolean[] down = this.canAttach(state, world, pos, Direction.DOWN);
        boolean tile = false;
        if (north[1] || south[1] || west[1] || east[1] || up[1] || down[1]) {
            tile = true;
        } else {
            TileEntity tileEntity = world.func_175625_s(pos);
            if (tileEntity instanceof EnergyCableTile) {
                EnergyCableTile cable = (EnergyCableTile)tileEntity;
                cable.getInventory().drop((World)world, pos);
                cable.func_145843_s();
            }
        }
        IFluidState ifluidstate = world.func_204610_c(pos);
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a((IProperty)NORTH, (Comparable)Boolean.valueOf(north[0] && !north[1]))).func_206870_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(south[0] && !south[1]))).func_206870_a((IProperty)WEST, (Comparable)Boolean.valueOf(west[0] && !west[1]))).func_206870_a((IProperty)EAST, (Comparable)Boolean.valueOf(east[0] && !east[1]))).func_206870_a((IProperty)UP, (Comparable)Boolean.valueOf(up[0] && !up[1]))).func_206870_a((IProperty)DOWN, (Comparable)Boolean.valueOf(down[0] && !down[1]))).func_206870_a((IProperty)TILE, (Comparable)Boolean.valueOf(tile))).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.func_206886_c() == Fluids.field_204546_a));
    }

    public boolean[] canAttach(BlockState state, IWorld world, BlockPos pos, Direction direction) {
        return new boolean[]{world.func_180495_p(pos.func_177972_a(direction)).func_177230_c() == this || this.canConnectEnergy((IBlockReader)world, pos, direction), this.canConnectEnergy((IBlockReader)world, pos, direction)};
    }

    public boolean canConnectEnergy(IBlockReader world, BlockPos pos, Direction direction) {
        TileEntity tile = world.func_175625_s(pos.func_177972_a(direction));
        return !(tile instanceof EnergyCableTile) && Energy.isPresent((TileEntity)tile, (Direction)direction);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{NORTH, EAST, SOUTH, WEST, UP, DOWN, TILE});
        super.func_206840_a(builder);
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        if (world.field_72995_K) {
            return;
        }
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof EnergyCableTile) {
            EnergyCableTile cable = (EnergyCableTile)tileEntity;
            for (Direction direction : Direction.values()) {
                if (!cable.canExtractEnergy(direction)) continue;
                cable.search((Block)this, direction);
            }
        } else {
            this.findCables((IWorld)world, pos, pos);
        }
    }

    public void func_220082_b(BlockState state, World world, BlockPos pos, BlockState oldState, boolean isMoving) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof EnergyCableTile) {
            EnergyCableTile cable = (EnergyCableTile)tileEntity;
            cable.energySides.clear();
            for (Direction direction : Direction.values()) {
                if (!this.canConnectEnergy((IBlockReader)world, pos, direction)) continue;
                cable.energySides.add(direction);
            }
            cable.markDirtyAndSync();
        }
        super.func_220082_b(state, world, pos, oldState, isMoving);
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        this.findCables((IWorld)world, pos, pos);
        super.func_196243_a(state, world, pos, newState, isMoving);
    }

    public void searchCables(IWorld world, BlockPos pos, EnergyCableTile first, Direction side) {
        if (!first.proxyMap.get((Object)side).searchCache.contains(pos)) {
            for (Direction direction : Direction.values()) {
                BlockState state;
                BlockPos blockPos = pos.func_177972_a(direction);
                if (blockPos.equals((Object)first.func_174877_v()) || (state = world.func_180495_p(blockPos)).func_177230_c() != this) continue;
                TileEntity tileEntity = world.func_175625_s(blockPos);
                if (tileEntity instanceof EnergyCableTile) {
                    EnergyCableTile cable = (EnergyCableTile)tileEntity;
                    first.proxyMap.get(side).add(blockPos);
                }
                EnergyCableBlock cableBlock = (EnergyCableBlock)state.func_177230_c();
                first.proxyMap.get((Object)side).searchCache.add(pos);
                cableBlock.searchCables(world, blockPos, first, side);
            }
        }
    }

    public void findCables(IWorld world, BlockPos poss, BlockPos pos) {
        Set<BlockPos> ss = CACHE.get(poss);
        if (ss == null) {
            ss = new HashSet<BlockPos>();
        }
        if (!ss.contains(pos)) {
            for (Direction direction : Direction.values()) {
                BlockPos blockPos = pos.func_177972_a(direction);
                BlockState state = world.func_180495_p(blockPos);
                if (state.func_177230_c() != this) continue;
                TileEntity tileEntity = world.func_175625_s(blockPos);
                if (tileEntity instanceof EnergyCableTile) {
                    EnergyCableTile cable = (EnergyCableTile)tileEntity;
                    for (Direction side : Direction.values()) {
                        cable.proxyMap.get(side).cables().clear();
                        cable.search((Block)this, side);
                    }
                }
                EnergyCableBlock cableBlock = (EnergyCableBlock)state.func_177230_c();
                ss.add(pos);
                CACHE.put(poss, ss);
                cableBlock.findCables(world, poss, blockPos);
            }
        }
        CACHE.clear();
    }

    public static Optional<Direction> getHitSide(Vec3d hit, BlockPos pos) {
        double x = hit.field_72450_a - (double)pos.func_177958_n();
        double y = hit.field_72448_b - (double)pos.func_177956_o();
        double z = hit.field_72449_c - (double)pos.func_177952_p();
        if (x > 0.0 && x < 0.4) {
            return Optional.of(Direction.WEST);
        }
        if (x > 0.6 && x < 1.0) {
            return Optional.of(Direction.EAST);
        }
        if (z > 0.0 && z < 0.4) {
            return Optional.of(Direction.NORTH);
        }
        if (z > 0.6 && z < 1.0) {
            return Optional.of(Direction.SOUTH);
        }
        if (y > 0.6 && y < 1.0) {
            return Optional.of(Direction.UP);
        }
        if (y > 0.0 && y < 0.4) {
            return Optional.of(Direction.DOWN);
        }
        return Optional.empty();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean addDestroyEffects(BlockState state, World world, BlockPos pos, ParticleManager manager) {
        VoxelShape voxelshape = CABLE;
        voxelshape.func_197755_b((x, y, z, xx, yy, zz) -> {
            double d1 = Math.min(1.0, xx - x);
            double d2 = Math.min(1.0, yy - y);
            double d3 = Math.min(1.0, zz - z);
            int i = Math.max(2, MathHelper.func_76143_f((double)(d1 / 0.25)));
            int j = Math.max(2, MathHelper.func_76143_f((double)(d2 / 0.25)));
            int k = Math.max(2, MathHelper.func_76143_f((double)(d3 / 0.25)));
            for (int l = 0; l < i; ++l) {
                for (int i1 = 0; i1 < j; ++i1) {
                    for (int j1 = 0; j1 < k; ++j1) {
                        double d4 = ((double)l + 0.5) / (double)i;
                        double d5 = ((double)i1 + 0.5) / (double)j;
                        double d6 = ((double)j1 + 0.5) / (double)k;
                        double d7 = d4 * d1 + x;
                        double d8 = d5 * d2 + y;
                        double d9 = d6 * d3 + z;
                        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new DiggingParticle(world, (double)pos.func_177958_n() + d7, (double)pos.func_177956_o() + d8, (double)pos.func_177952_p() + d9, d4 - 0.5, d5 - 0.5, d6 - 0.5, state).func_174846_a(pos));
                    }
                }
            }
        });
        return true;
    }
}

