/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.aura.type.IAuraType;
import de.ellpeck.naturesaura.recipes.ModRecipe;
import de.ellpeck.naturesaura.recipes.ModRecipes;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class AltarRecipe
extends ModRecipe {
    public final Ingredient input;
    public final ItemStack output;
    public final IAuraType requiredType;
    public final Ingredient catalyst;
    public final int aura;
    public final int time;

    public AltarRecipe(ResourceLocation name, Ingredient input, ItemStack output, IAuraType requiredType, Ingredient catalyst, int aura, int time) {
        super(name);
        this.input = input;
        this.output = output;
        this.requiredType = requiredType;
        this.catalyst = catalyst;
        this.aura = aura;
        this.time = time;
    }

    public ItemStack func_77571_b() {
        return this.output;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return ModRecipes.ALTAR_SERIAIZER;
    }

    public IRecipeType<?> func_222127_g() {
        return ModRecipes.ALTAR_TYPE;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<AltarRecipe> {
        public AltarRecipe read(ResourceLocation recipeId, JsonObject json) {
            return new AltarRecipe(recipeId, Ingredient.func_199802_a((JsonElement)json.getAsJsonObject("input")), CraftingHelper.getItemStack((JsonObject)json.getAsJsonObject("output"), (boolean)true), NaturesAuraAPI.AURA_TYPES.get(new ResourceLocation(json.get("aura_type").getAsString())), json.has("catalyst") ? Ingredient.func_199802_a((JsonElement)json.getAsJsonObject("catalyst")) : Ingredient.field_193370_a, json.get("aura").getAsInt(), json.get("time").getAsInt());
        }

        @Nullable
        public AltarRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            return new AltarRecipe(recipeId, Ingredient.func_199566_b((PacketBuffer)buffer), buffer.func_150791_c(), NaturesAuraAPI.AURA_TYPES.get(buffer.func_192575_l()), Ingredient.func_199566_b((PacketBuffer)buffer), buffer.readInt(), buffer.readInt());
        }

        public void write(PacketBuffer buffer, AltarRecipe recipe) {
            recipe.input.func_199564_a(buffer);
            buffer.func_150788_a(recipe.output);
            buffer.func_192572_a(recipe.requiredType.getName());
            recipe.catalyst.func_199564_a(buffer);
            buffer.writeInt(recipe.aura);
            buffer.writeInt(recipe.time);
        }
    }
}

