/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.items;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import de.ellpeck.naturesaura.api.render.IVisualizable;
import de.ellpeck.naturesaura.items.ItemImpl;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ItemRangeVisualizer
extends ItemImpl {
    public static final ListMultimap<DimensionType, BlockPos> VISUALIZED_BLOCKS = ArrayListMultimap.create();
    public static final ListMultimap<DimensionType, Entity> VISUALIZED_ENTITIES = ArrayListMultimap.create();
    public static final ListMultimap<DimensionType, BlockPos> VISUALIZED_RAILS = ArrayListMultimap.create();

    public ItemRangeVisualizer() {
        super("range_visualizer", new Item.Properties().func_200917_a(1));
        MinecraftForge.EVENT_BUS.register((Object)new EventHandler());
    }

    public static void clear() {
        if (!VISUALIZED_BLOCKS.isEmpty()) {
            VISUALIZED_BLOCKS.clear();
        }
        if (!VISUALIZED_ENTITIES.isEmpty()) {
            VISUALIZED_ENTITIES.clear();
        }
        if (!VISUALIZED_RAILS.isEmpty()) {
            VISUALIZED_RAILS.clear();
        }
    }

    public static <T> void visualize(PlayerEntity player, ListMultimap<DimensionType, T> map, DimensionType dim, T value) {
        if (map.containsEntry((Object)dim, value)) {
            map.remove((Object)dim, value);
            player.func_146105_b((ITextComponent)new TranslationTextComponent("info.naturesaura.range_visualizer.end", new Object[0]), true);
        } else {
            map.put((Object)dim, value);
            player.func_146105_b((ITextComponent)new TranslationTextComponent("info.naturesaura.range_visualizer.start", new Object[0]), true);
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (playerIn.func_225608_bj_()) {
            ItemRangeVisualizer.clear();
            playerIn.func_146105_b((ITextComponent)new TranslationTextComponent("info.naturesaura.range_visualizer.end_all", new Object[0]), true);
            return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
        }
        return new ActionResult(ActionResultType.PASS, (Object)stack);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        BlockPos pos;
        World world = context.func_195991_k();
        BlockState state = world.func_180495_p(pos = context.func_195995_a());
        Block block = state.func_177230_c();
        if (block instanceof IVisualizable) {
            if (world.field_72995_K) {
                ItemRangeVisualizer.visualize(context.func_195999_j(), VISUALIZED_BLOCKS, world.func_201675_m().func_186058_p(), pos);
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public class EventHandler {
        @SubscribeEvent
        public void onInteract(PlayerInteractEvent.EntityInteractSpecific event) {
            ItemStack stack = event.getItemStack();
            if (stack.func_190926_b() || stack.func_77973_b() != ItemRangeVisualizer.this) {
                return;
            }
            Entity entity = event.getTarget();
            if (entity instanceof IVisualizable) {
                if (entity.field_70170_p.field_72995_K) {
                    DimensionType dim = entity.field_70170_p.func_201675_m().func_186058_p();
                    ItemRangeVisualizer.visualize(event.getPlayer(), VISUALIZED_ENTITIES, dim, entity);
                }
                event.getPlayer().func_184609_a(event.getHand());
                event.setCancellationResult(ActionResultType.SUCCESS);
                event.setCanceled(true);
            }
        }
    }
}

