/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.items;

import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.data.ItemModelGenerator;
import de.ellpeck.naturesaura.items.ItemImpl;
import de.ellpeck.naturesaura.misc.ColoredBlockHelper;
import de.ellpeck.naturesaura.reg.IColorProvidingItem;
import de.ellpeck.naturesaura.reg.ICustomItemModel;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemColorChanger
extends ItemImpl
implements IColorProvidingItem,
ICustomItemModel {
    public ItemColorChanger() {
        super("color_changer", new Item.Properties().func_200917_a(1));
        this.func_185043_a(new ResourceLocation("naturesaura", "fill_mode"), (stack, worldIn, entityIn) -> ItemColorChanger.isFillMode(stack) ? 1.0f : 0.0f);
        this.func_185043_a(new ResourceLocation("naturesaura", "has_color"), (stack, worldIn, entityIn) -> ItemColorChanger.getStoredColor(stack) != null ? 1.0f : 0.0f);
    }

    private static boolean changeOrCopyColor(PlayerEntity player, ItemStack stack, World world, BlockPos pos, DyeColor firstColor) {
        Block block = world.func_180495_p(pos).func_177230_c();
        List<Block> blocks = ColoredBlockHelper.getBlocksContaining(block);
        if (blocks == null) {
            return false;
        }
        DyeColor color = DyeColor.func_196056_a((int)blocks.indexOf(block));
        if (firstColor == null || color == firstColor) {
            DyeColor stored = ItemColorChanger.getStoredColor(stack);
            if (player.func_225608_bj_()) {
                if (stored != color) {
                    world.func_184148_a(player, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187630_M, SoundCategory.PLAYERS, 0.65f, 1.0f);
                    if (!world.field_72995_K) {
                        ItemColorChanger.storeColor(stack, color);
                    }
                    return true;
                }
            } else if (stored != null && stored != color && NaturesAuraAPI.instance().extractAuraFromPlayer(player, 1000, world.field_72995_K)) {
                if (firstColor == null) {
                    world.func_184148_a(player, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187624_K, SoundCategory.PLAYERS, 0.65f, 1.0f);
                }
                if (!world.field_72995_K) {
                    world.func_175656_a(pos, blocks.get(stored.func_196059_a()).func_176223_P());
                    if (ItemColorChanger.isFillMode(stack)) {
                        for (Direction off : Direction.values()) {
                            ItemColorChanger.changeOrCopyColor(player, stack, world, pos.func_177972_a(off), color);
                        }
                    }
                }
                return true;
            }
        }
        return false;
    }

    private static DyeColor getStoredColor(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return null;
        }
        int color = stack.func_77978_p().func_74762_e("color");
        return DyeColor.func_196056_a((int)color);
    }

    private static void storeColor(ItemStack stack, DyeColor color) {
        stack.func_196082_o().func_74768_a("color", color.func_196059_a());
    }

    private static boolean isFillMode(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return false;
        }
        return stack.func_77978_p().func_74767_n("fill");
    }

    private static void setFillMode(ItemStack stack, boolean fill) {
        stack.func_196082_o().func_74757_a("fill", fill);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        ItemStack stack = context.func_195999_j().func_184586_b(context.func_221531_n());
        if (ItemColorChanger.changeOrCopyColor(context.func_195999_j(), stack, context.func_195991_k(), context.func_195995_a(), null)) {
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (playerIn.func_225608_bj_() && ItemColorChanger.getStoredColor(stack) != null) {
            worldIn.func_184148_a(playerIn, playerIn.func_226277_ct_(), playerIn.func_226278_cu_(), playerIn.func_226281_cx_(), SoundEvents.field_187633_N, SoundCategory.PLAYERS, 0.65f, 1.0f);
            if (!worldIn.field_72995_K) {
                ItemColorChanger.setFillMode(stack, !ItemColorChanger.isFillMode(stack));
            }
            return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
        }
        return new ActionResult(ActionResultType.PASS, (Object)stack);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public IItemColor getItemColor() {
        return (stack, tintIndex) -> {
            DyeColor color;
            if (tintIndex > 0 && (color = ItemColorChanger.getStoredColor(stack)) != null) {
                return color.getColorValue();
            }
            return 0xFFFFFF;
        };
    }

    @Override
    public void generateCustomItemModel(ItemModelGenerator generator) {
    }
}

