/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.gen;

import de.ellpeck.naturesaura.blocks.ModBlocks;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class WorldGenNetherWartMushroom
extends Feature<NoFeatureConfig> {
    public WorldGenNetherWartMushroom() {
        super(d -> NoFeatureConfig.field_202429_e);
    }

    public boolean place(IWorld worldIn, ChunkGenerator<? extends GenerationSettings> generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        int i;
        int height = rand.nextInt(5) + 4;
        if (rand.nextInt(10) == 0) {
            height += 5;
        }
        for (i = 1; i < height; ++i) {
            BlockPos offset = pos.func_177981_b(i);
            if (!worldIn.func_217375_a(offset, s -> !s.canBeReplacedByLogs((IWorldReader)worldIn, offset))) continue;
            return false;
        }
        this.func_202278_a((IWorldWriter)worldIn, pos, Blocks.field_150350_a.func_176223_P());
        for (i = 0; i < height; ++i) {
            this.placeIfPossible(worldIn, pos.func_177981_b(i), Blocks.field_189878_dg);
        }
        int rad = 3;
        for (int x = -rad; x <= rad; ++x) {
            for (int z = -rad; z <= rad; ++z) {
                int absX = Math.abs(x);
                int absZ = Math.abs(z);
                if (absX <= 1 && absZ <= 1) {
                    this.placeIfPossible(worldIn, pos.func_177982_a(x, height, z), ModBlocks.NETHER_WART_MUSHROOM);
                    continue;
                }
                if (absX <= 2 && absZ <= 2 && absX != absZ) {
                    this.placeIfPossible(worldIn, pos.func_177982_a(x, height - 1, z), ModBlocks.NETHER_WART_MUSHROOM);
                    continue;
                }
                if (absX >= rad - 1 && absZ >= rad - 1 && (absX != rad - 1 || absZ != rad - 1)) continue;
                this.placeIfPossible(worldIn, pos.func_177982_a(x, height - 2, z), ModBlocks.NETHER_WART_MUSHROOM);
            }
        }
        return true;
    }

    private void placeIfPossible(IWorld world, BlockPos pos, Block block) {
        if (world.func_217375_a(pos, s -> s.canBeReplacedByLogs((IWorldReader)world, pos))) {
            world.func_180501_a(pos, block.func_176223_P(), 19);
        }
    }
}

