/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks.tiles;

import de.ellpeck.naturesaura.blocks.tiles.ModTileEntities;
import de.ellpeck.naturesaura.blocks.tiles.TileEntityImpl;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TileEntityItemDistributor
extends TileEntityImpl
implements ITickableTileEntity {
    private int cooldown;
    private Direction currentSide = Direction.NORTH;
    public boolean isRandomMode;

    public TileEntityItemDistributor() {
        super(ModTileEntities.ITEM_DISTRIBUTOR);
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.cooldown > 0) {
            --this.cooldown;
            return;
        }
        this.cooldown = 1;
        IItemHandler above = this.getHandler(Direction.UP);
        if (above == null) {
            return;
        }
        IItemHandler dest = this.getNextSide();
        if (dest == null) {
            return;
        }
        for (int i = 0; i < above.getSlots(); ++i) {
            ItemStack stack = above.extractItem(i, 1, true);
            if (stack.func_190926_b()) continue;
            for (int j = 0; j < dest.getSlots(); ++j) {
                ItemStack remain = dest.insertItem(j, stack, false);
                if (ItemStack.func_77989_b((ItemStack)remain, (ItemStack)stack)) continue;
                above.extractItem(i, 1, false);
                this.cooldown = 3;
                return;
            }
        }
    }

    private IItemHandler getHandler(Direction direction) {
        BlockPos offset = this.field_174879_c.func_177972_a(direction);
        TileEntity tile = this.field_145850_b.func_175625_s(offset);
        if (tile == null) {
            return null;
        }
        return (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, direction.func_176734_d()).orElse(null);
    }

    private IItemHandler getNextSide() {
        if (this.isRandomMode) {
            ArrayList<IItemHandler> handlers = new ArrayList<IItemHandler>();
            for (int i = 0; i < 4; ++i) {
                IItemHandler handler = this.getHandler(Direction.func_176731_b((int)i));
                if (handler == null) continue;
                handlers.add(handler);
            }
            if (handlers.isEmpty()) {
                return null;
            }
            return (IItemHandler)handlers.get(this.field_145850_b.field_73012_v.nextInt(handlers.size()));
        }
        for (int i = 0; i < 4; ++i) {
            this.currentSide = this.currentSide.func_176746_e();
            IItemHandler handler = this.getHandler(this.currentSide);
            if (handler == null) continue;
            return handler;
        }
        return null;
    }

    @Override
    public void writeNBT(CompoundNBT compound, TileEntityImpl.SaveType type) {
        super.writeNBT(compound, type);
        if (type == TileEntityImpl.SaveType.TILE) {
            compound.func_74768_a("cooldown", this.cooldown);
            compound.func_74768_a("side", this.currentSide.ordinal());
        }
        if (type != TileEntityImpl.SaveType.BLOCK) {
            compound.func_74757_a("random", this.isRandomMode);
        }
    }

    @Override
    public void readNBT(CompoundNBT compound, TileEntityImpl.SaveType type) {
        super.readNBT(compound, type);
        if (type == TileEntityImpl.SaveType.TILE) {
            this.cooldown = compound.func_74762_e("cooldown");
            this.currentSide = Direction.values()[compound.func_74762_e("side")];
        }
        if (type != TileEntityImpl.SaveType.BLOCK) {
            this.isRandomMode = compound.func_74767_n("random");
        }
    }
}

