/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.api.aura.chunk;

import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.aura.type.IAuraType;
import java.util.function.BiConsumer;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.util.INBTSerializable;

public interface IAuraChunk
extends INBTSerializable<CompoundNBT> {
    public static final int DEFAULT_AURA = 1000000;

    public static IAuraChunk getAuraChunk(IWorld world, BlockPos pos) {
        Chunk chunk = (Chunk)world.func_217349_x(pos);
        return (IAuraChunk)chunk.getCapability(NaturesAuraAPI.capAuraChunk, null).orElse(null);
    }

    public static void getSpotsInArea(IWorld world, BlockPos pos, int radius, BiConsumer<BlockPos, Integer> consumer) {
        NaturesAuraAPI.instance().getAuraSpotsInArea((World)world, pos, radius, consumer);
    }

    public static int getSpotAmountInArea(IWorld world, BlockPos pos, int radius) {
        return NaturesAuraAPI.instance().getSpotAmountInArea((World)world, pos, radius);
    }

    public static int getAuraInArea(IWorld world, BlockPos pos, int radius) {
        return NaturesAuraAPI.instance().getAuraInArea((World)world, pos, radius);
    }

    public static int triangulateAuraInArea(IWorld world, BlockPos pos, int radius) {
        return NaturesAuraAPI.instance().triangulateAuraInArea((World)world, pos, radius);
    }

    public static BlockPos getLowestSpot(IWorld world, BlockPos pos, int radius, BlockPos defaultSpot) {
        return NaturesAuraAPI.instance().getLowestAuraDrainSpot((World)world, pos, radius, defaultSpot);
    }

    public static BlockPos getHighestSpot(IWorld world, BlockPos pos, int radius, BlockPos defaultSpot) {
        return NaturesAuraAPI.instance().getHighestAuraDrainSpot((World)world, pos, radius, defaultSpot);
    }

    public int drainAura(BlockPos var1, int var2, boolean var3, boolean var4);

    public int drainAura(BlockPos var1, int var2);

    public int storeAura(BlockPos var1, int var2, boolean var3, boolean var4);

    public int storeAura(BlockPos var1, int var2);

    public int getDrainSpot(BlockPos var1);

    public IAuraType getType();

    public void markDirty();
}

