/*
 * Decompiled with CFR 0.152.
 */
package mcjty.tools.cache;

import javax.annotation.Nonnull;
import net.minecraft.world.dimension.DimensionType;

public class StructureCacheEntry {
    @Nonnull
    private final String structure;
    private final DimensionType dimension;
    private final long chunkpos;

    public StructureCacheEntry(@Nonnull String structure, DimensionType dimension, long chunkpos) {
        this.structure = structure;
        this.dimension = dimension;
        this.chunkpos = chunkpos;
    }

    @Nonnull
    public String getStructure() {
        return this.structure;
    }

    public DimensionType getDimension() {
        return this.dimension;
    }

    public long getChunkpos() {
        return this.chunkpos;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StructureCacheEntry that = (StructureCacheEntry)o;
        if (this.dimension != that.dimension) {
            return false;
        }
        if (this.chunkpos != that.chunkpos) {
            return false;
        }
        return this.structure.equals(that.structure);
    }

    public int hashCode() {
        int result = this.structure.hashCode();
        result = 31 * result + this.dimension.hashCode();
        result = 31 * result + (int)(this.chunkpos ^ this.chunkpos >>> 32);
        return result;
    }
}

