/*
 * Decompiled with CFR 0.152.
 */
package com.exidex.swingthroughgrass;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public final class LeftClickEventHandler {
    public static final List<Predicate<LivingEntity>> PREDICATES = Lists.newArrayList();

    private LeftClickEventHandler() {
    }

    @SubscribeEvent
    public static void onLeftClick(PlayerInteractEvent.LeftClickBlock event) {
        BlockState state = event.getWorld().func_180495_p(event.getPos());
        if (!state.func_196952_d((IBlockReader)event.getWorld(), event.getPos()).func_197766_b()) {
            return;
        }
        PlayerEntity player = event.getPlayer();
        if (player == null) {
            return;
        }
        EntityRayTraceResult rayTraceResult = LeftClickEventHandler.rayTraceEntity(player, 1.0f, 4.5);
        if (rayTraceResult != null && !event.getWorld().field_72995_K) {
            player.func_71059_n(rayTraceResult.func_216348_a());
            player.func_184821_cY();
        }
    }

    @Nullable
    private static EntityRayTraceResult rayTraceEntity(PlayerEntity player, float partialTicks, double blockReachDistance) {
        Vec3d from = player.func_174824_e(partialTicks);
        Vec3d look = player.func_70676_i(partialTicks);
        Vec3d to = from.func_72441_c(look.field_72450_a * blockReachDistance, look.field_72448_b * blockReachDistance, look.field_72449_c * blockReachDistance);
        return ProjectileHelper.func_221271_a((World)player.field_70170_p, (Entity)player, (Vec3d)from, (Vec3d)to, (AxisAlignedBB)new AxisAlignedBB(from, to), EntityPredicates.field_188444_d.and(e -> e != null && e.func_70067_L() && e instanceof LivingEntity && !(e instanceof FakePlayer) && PREDICATES.stream().allMatch(predicate -> predicate.test((LivingEntity)e))));
    }
}

