/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorageaddons.config;

import net.minecraftforge.common.ForgeConfigSpec;

public class ServerConfig {
    private ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
    private ForgeConfigSpec spec;
    private WirelessCraftingGrid wirelessCraftingGrid = new WirelessCraftingGrid();

    public ServerConfig() {
        this.spec = this.builder.build();
    }

    public WirelessCraftingGrid getWirelessCraftingGrid() {
        return this.wirelessCraftingGrid;
    }

    public ForgeConfigSpec getSpec() {
        return this.spec;
    }

    public class WirelessCraftingGrid {
        private final ForgeConfigSpec.BooleanValue useEnergy;
        private final ForgeConfigSpec.IntValue capacity;
        private final ForgeConfigSpec.IntValue openUsage;
        private final ForgeConfigSpec.IntValue craftUsage;
        private final ForgeConfigSpec.IntValue clearUsage;

        public WirelessCraftingGrid() {
            ServerConfig.this.builder.push("wirelessCraftingGrid");
            this.useEnergy = ServerConfig.this.builder.comment("Whether the Wireless Crafting Grid uses energy").define("useEnergy", true);
            this.capacity = ServerConfig.this.builder.comment("The energy capacity of the Wireless Crafting Grid").defineInRange("capacity", 3200, 0, Integer.MAX_VALUE);
            this.openUsage = ServerConfig.this.builder.comment("The energy used by the Wireless Crafting Grid to open").defineInRange("openUsage", 30, 0, Integer.MAX_VALUE);
            this.craftUsage = ServerConfig.this.builder.comment("The energy used by the Wireless Crafting Grid to craft an item").defineInRange("craftUsage", 1, 0, Integer.MAX_VALUE);
            this.clearUsage = ServerConfig.this.builder.comment("The energy used by the Wireless Crafting Grid to clear the crafting matrix").defineInRange("clearUsage", 10, 0, Integer.MAX_VALUE);
            ServerConfig.this.builder.pop();
        }

        public boolean getUseEnergy() {
            return (Boolean)this.useEnergy.get();
        }

        public int getCapacity() {
            return (Integer)this.capacity.get();
        }

        public int getOpenUsage() {
            return (Integer)this.openUsage.get();
        }

        public int getCraftUsage() {
            return (Integer)this.craftUsage.get();
        }

        public int getClearUsage() {
            return (Integer)this.clearUsage.get();
        }
    }
}

