/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.jeitweaker;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.actions.IAction;
import com.blamejared.crafttweaker.api.actions.IRuntimeAction;
import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.item.IItemStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraftforge.fml.LogicalSide;
import org.openzen.zencode.java.ZenCodeType;

@ZenCodeType.Name(value="mods.jei.JEI")
@ZenRegister
public class JEIManager {
    public static final List<IItemStack> HIDDEN_ITEMS = new ArrayList<IItemStack>();
    public static final List<String> HIDDEN_RECIPE_CATEGORIES = new ArrayList<String>();
    public static final Map<IItemStack, String[]> ITEM_DESCRIPTIONS = new HashMap<IItemStack, String[]>();

    @ZenCodeType.Method
    public static void hideItem(final IItemStack stack) {
        CraftTweakerAPI.apply((IAction)new IRuntimeAction(){

            public void apply() {
                HIDDEN_ITEMS.add(stack);
            }

            public String describe() {
                return "JEI Hiding Item: " + stack.getCommandString();
            }

            public boolean shouldApplyOn(LogicalSide side) {
                return side.isClient();
            }
        });
    }

    @ZenCodeType.Method
    public static void addInfo(final IItemStack stack, final String[] string) {
        CraftTweakerAPI.apply((IAction)new IRuntimeAction(){

            public void apply() {
                ITEM_DESCRIPTIONS.put(stack, string);
            }

            public String describe() {
                return "Adding JEI Info for: " + stack.getCommandString();
            }

            public boolean shouldApplyOn(LogicalSide side) {
                return side.isClient();
            }
        });
    }

    @ZenCodeType.Method
    public static void hideCategory(final String category) {
        CraftTweakerAPI.apply((IAction)new IRuntimeAction(){

            public void apply() {
                HIDDEN_RECIPE_CATEGORIES.add(category);
            }

            public String describe() {
                return "JEI Hiding Category: " + category;
            }

            public boolean shouldApplyOn(LogicalSide side) {
                return side.isClient();
            }
        });
    }
}

