/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.jeitweaker;

import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.jeitweaker.JEIManager;
import java.util.Collection;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

@JeiPlugin
public class JEIAddonPlugin
implements IModPlugin {
    public void registerRecipes(IRecipeRegistration registration) {
        IIngredientManager ingredientManager = registration.getIngredientManager();
        IIngredientType type = ingredientManager.getIngredientType(ItemStack.class);
        JEIManager.ITEM_DESCRIPTIONS.forEach((key, value) -> registration.addIngredientInfo((Object)key.getInternal(), type, value));
        JEIManager.ITEM_DESCRIPTIONS.clear();
    }

    public void onRuntimeAvailable(IJeiRuntime iJeiRuntime) {
        IIngredientManager ingredientManager = iJeiRuntime.getIngredientManager();
        IIngredientType type = ingredientManager.getIngredientType(ItemStack.class);
        if (!JEIManager.HIDDEN_ITEMS.isEmpty()) {
            ingredientManager.removeIngredientsAtRuntime(type, (Collection)JEIManager.HIDDEN_ITEMS.stream().map(IItemStack::getInternal).collect(Collectors.toList()));
        }
        JEIManager.HIDDEN_RECIPE_CATEGORIES.stream().map(ResourceLocation::new).forEach(arg_0 -> ((IRecipeManager)iJeiRuntime.getRecipeManager()).hideRecipeCategory(arg_0));
        JEIManager.HIDDEN_ITEMS.clear();
        JEIManager.HIDDEN_RECIPE_CATEGORIES.clear();
    }

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("jeitweaker:main");
    }
}

