/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.forge.clothconfig2.impl.builders;

import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import me.shedaniel.forge.clothconfig2.gui.entries.DropdownBoxEntry;
import me.shedaniel.forge.clothconfig2.impl.builders.FieldBuilder;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DropdownMenuBuilder<T>
extends FieldBuilder<T, DropdownBoxEntry<T>> {
    protected DropdownBoxEntry.SelectionTopCellElement<T> topCellElement;
    protected DropdownBoxEntry.SelectionCellCreator<T> cellCreator;
    protected Function<T, Optional<String[]>> tooltipSupplier = str -> Optional.empty();
    protected Consumer<T> saveConsumer = null;
    protected Iterable<T> selections = Collections.emptyList();

    public DropdownMenuBuilder(String resetButtonKey, String fieldNameKey, DropdownBoxEntry.SelectionTopCellElement<T> topCellElement, DropdownBoxEntry.SelectionCellCreator<T> cellCreator) {
        super(resetButtonKey, fieldNameKey);
        this.topCellElement = Objects.requireNonNull(topCellElement);
        this.cellCreator = Objects.requireNonNull(cellCreator);
    }

    public DropdownMenuBuilder<T> setSelections(Iterable<T> selections) {
        this.selections = selections;
        return this;
    }

    public DropdownMenuBuilder<T> setDefaultValue(Supplier<T> defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public DropdownMenuBuilder<T> setDefaultValue(T defaultValue) {
        this.defaultValue = () -> Objects.requireNonNull(defaultValue);
        return this;
    }

    public DropdownMenuBuilder<T> setSaveConsumer(Consumer<T> saveConsumer) {
        this.saveConsumer = saveConsumer;
        return this;
    }

    public DropdownMenuBuilder<T> setTooltipSupplier(Supplier<Optional<String[]>> tooltipSupplier) {
        this.tooltipSupplier = str -> (Optional)tooltipSupplier.get();
        return this;
    }

    public DropdownMenuBuilder<T> setTooltipSupplier(Function<T, Optional<String[]>> tooltipSupplier) {
        this.tooltipSupplier = tooltipSupplier;
        return this;
    }

    public DropdownMenuBuilder<T> setTooltip(Optional<String[]> tooltip) {
        this.tooltipSupplier = str -> tooltip;
        return this;
    }

    public DropdownMenuBuilder<T> setTooltip(String ... tooltip) {
        this.tooltipSupplier = str -> Optional.ofNullable(tooltip);
        return this;
    }

    public DropdownMenuBuilder<T> requireRestart() {
        this.requireRestart(true);
        return this;
    }

    public DropdownMenuBuilder<T> setErrorSupplier(Function<T, Optional<String>> errorSupplier) {
        this.errorSupplier = errorSupplier;
        return this;
    }

    @Override
    public DropdownBoxEntry<T> build() {
        DropdownBoxEntry<T> entry = new DropdownBoxEntry<T>(this.getFieldNameKey(), this.getResetButtonKey(), null, this.isRequireRestart(), this.defaultValue, this.saveConsumer, this.selections, this.topCellElement, this.cellCreator);
        entry.setTooltipSupplier(() -> this.tooltipSupplier.apply(entry.getValue()));
        if (this.errorSupplier != null) {
            entry.setErrorSupplier(() -> (Optional)this.errorSupplier.apply(entry.getValue()));
        }
        return entry;
    }

    public static class CellCreatorBuilder {
        public static <T> DropdownBoxEntry.SelectionCellCreator<T> of() {
            return new DropdownBoxEntry.DefaultSelectionCellCreator();
        }

        public static <T> DropdownBoxEntry.SelectionCellCreator<T> of(Function<T, String> toStringFunction) {
            return new DropdownBoxEntry.DefaultSelectionCellCreator<T>(toStringFunction);
        }

        public static <T> DropdownBoxEntry.SelectionCellCreator<T> ofWidth(final int cellWidth) {
            return new DropdownBoxEntry.DefaultSelectionCellCreator<T>(){

                @Override
                public int getCellWidth() {
                    return cellWidth;
                }
            };
        }

        public static <T> DropdownBoxEntry.SelectionCellCreator<T> ofWidth(final int cellWidth, Function<T, String> toStringFunction) {
            return new DropdownBoxEntry.DefaultSelectionCellCreator<T>(toStringFunction){

                @Override
                public int getCellWidth() {
                    return cellWidth;
                }
            };
        }

        public static <T> DropdownBoxEntry.SelectionCellCreator<T> ofCellCount(final int maxItems) {
            return new DropdownBoxEntry.DefaultSelectionCellCreator<T>(){

                @Override
                public int getDropBoxMaxHeight() {
                    return this.getCellHeight() * maxItems;
                }
            };
        }

        public static <T> DropdownBoxEntry.SelectionCellCreator<T> ofCellCount(final int maxItems, Function<T, String> toStringFunction) {
            return new DropdownBoxEntry.DefaultSelectionCellCreator<T>(toStringFunction){

                @Override
                public int getDropBoxMaxHeight() {
                    return this.getCellHeight() * maxItems;
                }
            };
        }

        public static <T> DropdownBoxEntry.SelectionCellCreator<T> of(final int cellWidth, final int maxItems) {
            return new DropdownBoxEntry.DefaultSelectionCellCreator<T>(){

                @Override
                public int getCellWidth() {
                    return cellWidth;
                }

                @Override
                public int getDropBoxMaxHeight() {
                    return this.getCellHeight() * maxItems;
                }
            };
        }

        public static <T> DropdownBoxEntry.SelectionCellCreator<T> of(final int cellWidth, final int maxItems, Function<T, String> toStringFunction) {
            return new DropdownBoxEntry.DefaultSelectionCellCreator<T>(toStringFunction){

                @Override
                public int getCellWidth() {
                    return cellWidth;
                }

                @Override
                public int getDropBoxMaxHeight() {
                    return this.getCellHeight() * maxItems;
                }
            };
        }

        public static <T> DropdownBoxEntry.SelectionCellCreator<T> of(final int cellHeight, final int cellWidth, final int maxItems) {
            return new DropdownBoxEntry.DefaultSelectionCellCreator<T>(){

                @Override
                public int getCellHeight() {
                    return cellHeight;
                }

                @Override
                public int getCellWidth() {
                    return cellWidth;
                }

                @Override
                public int getDropBoxMaxHeight() {
                    return this.getCellHeight() * maxItems;
                }
            };
        }

        public static <T> DropdownBoxEntry.SelectionCellCreator<T> of(final int cellHeight, final int cellWidth, final int maxItems, Function<T, String> toStringFunction) {
            return new DropdownBoxEntry.DefaultSelectionCellCreator<T>(toStringFunction){

                @Override
                public int getCellHeight() {
                    return cellHeight;
                }

                @Override
                public int getCellWidth() {
                    return cellWidth;
                }

                @Override
                public int getDropBoxMaxHeight() {
                    return this.getCellHeight() * maxItems;
                }
            };
        }

        public static DropdownBoxEntry.SelectionCellCreator<ResourceLocation> ofItemIdentifier() {
            return CellCreatorBuilder.ofItemIdentifier(20, 146, 7);
        }

        public static DropdownBoxEntry.SelectionCellCreator<ResourceLocation> ofItemIdentifier(int maxItems) {
            return CellCreatorBuilder.ofItemIdentifier(20, 146, maxItems);
        }

        public static DropdownBoxEntry.SelectionCellCreator<ResourceLocation> ofItemIdentifier(final int cellHeight, final int cellWidth, final int maxItems) {
            return new DropdownBoxEntry.DefaultSelectionCellCreator<ResourceLocation>(){

                @Override
                public DropdownBoxEntry.SelectionCellElement<ResourceLocation> create(ResourceLocation selection) {
                    final ItemStack s = new ItemStack((IItemProvider)Registry.field_212630_s.func_82594_a(selection));
                    return new DropdownBoxEntry.DefaultSelectionCellElement<ResourceLocation>(selection, this.toStringFunction){

                        @Override
                        public void render(int mouseX, int mouseY, int x, int y, int width, int height, float delta) {
                            boolean b;
                            this.rendering = true;
                            this.x = x;
                            this.y = y;
                            this.width = width;
                            this.height = height;
                            boolean bl = b = mouseX >= x && mouseX <= x + width && mouseY >= y && mouseY <= y + height;
                            if (b) {
                                CellCreatorBuilder.1.fill((int)(x + 1), (int)(y + 1), (int)(x + width - 1), (int)(y + height - 1), (int)-15132391);
                            }
                            Minecraft.func_71410_x().field_71466_p.func_175063_a((String)this.toStringFunction.apply(this.r), (float)(x + 6 + 18), (float)(y + 6), b ? 0xFFFFFF : 0x888888);
                            ItemRenderer itemRenderer = Minecraft.func_71410_x().func_175599_af();
                            itemRenderer.func_175042_a(s, x + 4, y + 2);
                        }
                    };
                }

                @Override
                public int getCellHeight() {
                    return cellHeight;
                }

                @Override
                public int getCellWidth() {
                    return cellWidth;
                }

                @Override
                public int getDropBoxMaxHeight() {
                    return this.getCellHeight() * maxItems;
                }
            };
        }

        public static DropdownBoxEntry.SelectionCellCreator<ResourceLocation> ofBlockIdentifier() {
            return CellCreatorBuilder.ofBlockIdentifier(20, 146, 7);
        }

        public static DropdownBoxEntry.SelectionCellCreator<ResourceLocation> ofBlockIdentifier(int maxItems) {
            return CellCreatorBuilder.ofBlockIdentifier(20, 146, maxItems);
        }

        public static DropdownBoxEntry.SelectionCellCreator<ResourceLocation> ofBlockIdentifier(final int cellHeight, final int cellWidth, final int maxItems) {
            return new DropdownBoxEntry.DefaultSelectionCellCreator<ResourceLocation>(){

                @Override
                public DropdownBoxEntry.SelectionCellElement<ResourceLocation> create(ResourceLocation selection) {
                    final ItemStack s = new ItemStack((IItemProvider)Registry.field_212618_g.func_82594_a(selection));
                    return new DropdownBoxEntry.DefaultSelectionCellElement<ResourceLocation>(selection, this.toStringFunction){

                        @Override
                        public void render(int mouseX, int mouseY, int x, int y, int width, int height, float delta) {
                            boolean b;
                            this.rendering = true;
                            this.x = x;
                            this.y = y;
                            this.width = width;
                            this.height = height;
                            boolean bl = b = mouseX >= x && mouseX <= x + width && mouseY >= y && mouseY <= y + height;
                            if (b) {
                                1.fill((int)(x + 1), (int)(y + 1), (int)(x + width - 1), (int)(y + height - 1), (int)-15132391);
                            }
                            Minecraft.func_71410_x().field_71466_p.func_175063_a((String)this.toStringFunction.apply(this.r), (float)(x + 6 + 18), (float)(y + 6), b ? 0xFFFFFF : 0x888888);
                            ItemRenderer itemRenderer = Minecraft.func_71410_x().func_175599_af();
                            itemRenderer.func_175042_a(s, x + 4, y + 2);
                        }
                    };
                }

                @Override
                public int getCellHeight() {
                    return cellHeight;
                }

                @Override
                public int getCellWidth() {
                    return cellWidth;
                }

                @Override
                public int getDropBoxMaxHeight() {
                    return this.getCellHeight() * maxItems;
                }
            };
        }

        public static DropdownBoxEntry.SelectionCellCreator<Item> ofItemObject() {
            return CellCreatorBuilder.ofItemObject(20, 146, 7);
        }

        public static DropdownBoxEntry.SelectionCellCreator<Item> ofItemObject(int maxItems) {
            return CellCreatorBuilder.ofItemObject(20, 146, maxItems);
        }

        public static DropdownBoxEntry.SelectionCellCreator<Item> ofItemObject(final int cellHeight, final int cellWidth, final int maxItems) {
            return new DropdownBoxEntry.DefaultSelectionCellCreator<Item>(i -> Registry.field_212630_s.func_177774_c(i).toString()){

                @Override
                public DropdownBoxEntry.SelectionCellElement<Item> create(Item selection) {
                    final ItemStack s = new ItemStack((IItemProvider)selection);
                    return new DropdownBoxEntry.DefaultSelectionCellElement<Item>(selection, this.toStringFunction){

                        @Override
                        public void render(int mouseX, int mouseY, int x, int y, int width, int height, float delta) {
                            boolean b;
                            this.rendering = true;
                            this.x = x;
                            this.y = y;
                            this.width = width;
                            this.height = height;
                            boolean bl = b = mouseX >= x && mouseX <= x + width && mouseY >= y && mouseY <= y + height;
                            if (b) {
                                CellCreatorBuilder.1.fill((int)(x + 1), (int)(y + 1), (int)(x + width - 1), (int)(y + height - 1), (int)-15132391);
                            }
                            Minecraft.func_71410_x().field_71466_p.func_175063_a((String)this.toStringFunction.apply(this.r), (float)(x + 6 + 18), (float)(y + 6), b ? 0xFFFFFF : 0x888888);
                            ItemRenderer itemRenderer = Minecraft.func_71410_x().func_175599_af();
                            itemRenderer.func_175042_a(s, x + 4, y + 2);
                        }
                    };
                }

                @Override
                public int getCellHeight() {
                    return cellHeight;
                }

                @Override
                public int getCellWidth() {
                    return cellWidth;
                }

                @Override
                public int getDropBoxMaxHeight() {
                    return this.getCellHeight() * maxItems;
                }
            };
        }

        public static DropdownBoxEntry.SelectionCellCreator<Block> ofBlockObject() {
            return CellCreatorBuilder.ofBlockObject(20, 146, 7);
        }

        public static DropdownBoxEntry.SelectionCellCreator<Block> ofBlockObject(int maxItems) {
            return CellCreatorBuilder.ofBlockObject(20, 146, maxItems);
        }

        public static DropdownBoxEntry.SelectionCellCreator<Block> ofBlockObject(final int cellHeight, final int cellWidth, final int maxItems) {
            return new DropdownBoxEntry.DefaultSelectionCellCreator<Block>(i -> Registry.field_212618_g.func_177774_c(i).toString()){

                @Override
                public DropdownBoxEntry.SelectionCellElement<Block> create(Block selection) {
                    final ItemStack s = new ItemStack((IItemProvider)selection);
                    return new DropdownBoxEntry.DefaultSelectionCellElement<Block>(selection, this.toStringFunction){

                        @Override
                        public void render(int mouseX, int mouseY, int x, int y, int width, int height, float delta) {
                            boolean b;
                            this.rendering = true;
                            this.x = x;
                            this.y = y;
                            this.width = width;
                            this.height = height;
                            boolean bl = b = mouseX >= x && mouseX <= x + width && mouseY >= y && mouseY <= y + height;
                            if (b) {
                                CellCreatorBuilder.1.fill((int)(x + 1), (int)(y + 1), (int)(x + width - 1), (int)(y + height - 1), (int)-15132391);
                            }
                            Minecraft.func_71410_x().field_71466_p.func_175063_a((String)this.toStringFunction.apply(this.r), (float)(x + 6 + 18), (float)(y + 6), b ? 0xFFFFFF : 0x888888);
                            ItemRenderer itemRenderer = Minecraft.func_71410_x().func_175599_af();
                            itemRenderer.func_175042_a(s, x + 4, y + 2);
                        }
                    };
                }

                @Override
                public int getCellHeight() {
                    return cellHeight;
                }

                @Override
                public int getCellWidth() {
                    return cellWidth;
                }

                @Override
                public int getDropBoxMaxHeight() {
                    return this.getCellHeight() * maxItems;
                }
            };
        }
    }

    public static class TopCellElementBuilder {
        public static final Function<String, ResourceLocation> IDENTIFIER_FUNCTION = str -> {
            try {
                return new ResourceLocation(str);
            }
            catch (NumberFormatException e) {
                return null;
            }
        };
        public static final Function<String, ResourceLocation> ITEM_IDENTIFIER_FUNCTION = str -> {
            try {
                ResourceLocation identifier = new ResourceLocation(str);
                if (Registry.field_212630_s.func_218349_b(identifier).isPresent()) {
                    return identifier;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        };
        public static final Function<String, ResourceLocation> BLOCK_IDENTIFIER_FUNCTION = str -> {
            try {
                ResourceLocation identifier = new ResourceLocation(str);
                if (Registry.field_212618_g.func_218349_b(identifier).isPresent()) {
                    return identifier;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        };
        public static final Function<String, Item> ITEM_FUNCTION = str -> {
            try {
                return Registry.field_212630_s.func_218349_b(new ResourceLocation(str)).orElse(null);
            }
            catch (Exception exception) {
                return null;
            }
        };
        public static final Function<String, Block> BLOCK_FUNCTION = str -> {
            try {
                return Registry.field_212618_g.func_218349_b(new ResourceLocation(str)).orElse(null);
            }
            catch (Exception exception) {
                return null;
            }
        };
        private static final ItemStack BARRIER = new ItemStack((IItemProvider)Items.field_221803_eL);

        public static <T> DropdownBoxEntry.SelectionTopCellElement<T> of(T value, Function<String, T> toObjectFunction) {
            return TopCellElementBuilder.of(value, toObjectFunction, Object::toString);
        }

        public static <T> DropdownBoxEntry.SelectionTopCellElement<T> of(T value, Function<String, T> toObjectFunction, Function<T, String> toStringFunction) {
            return new DropdownBoxEntry.DefaultSelectionTopCellElement<T>(value, toObjectFunction, toStringFunction);
        }

        public static DropdownBoxEntry.SelectionTopCellElement<ResourceLocation> ofItemIdentifier(Item item) {
            return new DropdownBoxEntry.DefaultSelectionTopCellElement<ResourceLocation>(Registry.field_212630_s.func_177774_c((Object)item), ITEM_IDENTIFIER_FUNCTION, ResourceLocation::toString){

                @Override
                public void render(int mouseX, int mouseY, int x, int y, int width, int height, float delta) {
                    this.textFieldWidget.x = x + 4;
                    this.textFieldWidget.y = y + 6;
                    this.textFieldWidget.setWidth(width - 4 - 20);
                    this.textFieldWidget.func_146184_c(this.getParent().isEditable());
                    this.textFieldWidget.func_146193_g(this.getPreferredTextColor());
                    this.textFieldWidget.render(mouseX, mouseY, delta);
                    ItemRenderer itemRenderer = Minecraft.func_71410_x().func_175599_af();
                    ItemStack stack = this.hasConfigError() ? BARRIER : new ItemStack((IItemProvider)Registry.field_212630_s.func_82594_a((ResourceLocation)this.getValue()));
                    itemRenderer.func_175042_a(stack, x + width - 18, y + 2);
                }
            };
        }

        public static DropdownBoxEntry.SelectionTopCellElement<ResourceLocation> ofBlockIdentifier(Block block) {
            return new DropdownBoxEntry.DefaultSelectionTopCellElement<ResourceLocation>(Registry.field_212618_g.func_177774_c((Object)block), BLOCK_IDENTIFIER_FUNCTION, ResourceLocation::toString){

                @Override
                public void render(int mouseX, int mouseY, int x, int y, int width, int height, float delta) {
                    this.textFieldWidget.x = x + 4;
                    this.textFieldWidget.y = y + 6;
                    this.textFieldWidget.setWidth(width - 4 - 20);
                    this.textFieldWidget.func_146184_c(this.getParent().isEditable());
                    this.textFieldWidget.func_146193_g(this.getPreferredTextColor());
                    this.textFieldWidget.render(mouseX, mouseY, delta);
                    ItemRenderer itemRenderer = Minecraft.func_71410_x().func_175599_af();
                    ItemStack stack = this.hasConfigError() ? BARRIER : new ItemStack((IItemProvider)Registry.field_212618_g.func_82594_a((ResourceLocation)this.getValue()));
                    itemRenderer.func_175042_a(stack, x + width - 18, y + 2);
                }
            };
        }

        public static DropdownBoxEntry.SelectionTopCellElement<Item> ofItemObject(Item item) {
            return new DropdownBoxEntry.DefaultSelectionTopCellElement<Item>(item, ITEM_FUNCTION, i -> Registry.field_212630_s.func_177774_c(i).toString()){

                @Override
                public void render(int mouseX, int mouseY, int x, int y, int width, int height, float delta) {
                    this.textFieldWidget.x = x + 4;
                    this.textFieldWidget.y = y + 6;
                    this.textFieldWidget.setWidth(width - 4 - 20);
                    this.textFieldWidget.func_146184_c(this.getParent().isEditable());
                    this.textFieldWidget.func_146193_g(this.getPreferredTextColor());
                    this.textFieldWidget.render(mouseX, mouseY, delta);
                    ItemRenderer itemRenderer = Minecraft.func_71410_x().func_175599_af();
                    ItemStack stack = this.hasConfigError() ? BARRIER : new ItemStack((IItemProvider)this.getValue());
                    itemRenderer.func_175042_a(stack, x + width - 18, y + 2);
                }
            };
        }

        public static DropdownBoxEntry.SelectionTopCellElement<Block> ofBlockObject(Block block) {
            return new DropdownBoxEntry.DefaultSelectionTopCellElement<Block>(block, BLOCK_FUNCTION, i -> Registry.field_212618_g.func_177774_c(i).toString()){

                @Override
                public void render(int mouseX, int mouseY, int x, int y, int width, int height, float delta) {
                    this.textFieldWidget.x = x + 4;
                    this.textFieldWidget.y = y + 6;
                    this.textFieldWidget.setWidth(width - 4 - 20);
                    this.textFieldWidget.func_146184_c(this.getParent().isEditable());
                    this.textFieldWidget.func_146193_g(this.getPreferredTextColor());
                    this.textFieldWidget.render(mouseX, mouseY, delta);
                    ItemRenderer itemRenderer = Minecraft.func_71410_x().func_175599_af();
                    ItemStack stack = this.hasConfigError() ? BARRIER : new ItemStack((IItemProvider)this.getValue());
                    itemRenderer.func_175042_a(stack, x + width - 18, y + 2);
                }
            };
        }
    }
}

