/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.spell.trick.entity;

import net.minecraft.entity.Entity;
import net.minecraft.util.math.Vec3d;
import vazkii.psi.api.spell.EnumSpellStat;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellMetadata;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.param.ParamEntity;
import vazkii.psi.api.spell.param.ParamNumber;
import vazkii.psi.api.spell.piece.PieceTrick;

public class PieceTrickBlink
extends PieceTrick {
    SpellParam<Entity> target;
    SpellParam<Number> distance;

    public PieceTrickBlink(Spell spell) {
        super(spell);
    }

    @Override
    public void initParams() {
        this.target = new ParamEntity("psi.spellparam.target", SpellParam.YELLOW, false, false);
        this.addParam(this.target);
        this.distance = new ParamNumber("psi.spellparam.distance", SpellParam.RED, false, true);
        this.addParam(this.distance);
    }

    @Override
    public void addToMetadata(SpellMetadata meta) throws SpellCompilationException {
        super.addToMetadata(meta);
        Double distanceVal = (Double)this.getParamEvaluation(this.distance);
        if (distanceVal == null) {
            distanceVal = 1.0;
        }
        meta.addStat(EnumSpellStat.POTENCY, (int)(Math.abs(distanceVal) * 30.0));
        meta.addStat(EnumSpellStat.COST, (int)(Math.abs(distanceVal) * 40.0));
    }

    @Override
    public Object execute(SpellContext context) throws SpellRuntimeException {
        Entity targetVal = this.getParamValue(context, this.target);
        double distanceVal = this.getParamValue(context, this.distance).doubleValue();
        PieceTrickBlink.blink(context, targetVal, distanceVal);
        return null;
    }

    public static void blink(SpellContext context, Entity e, double dist) throws SpellRuntimeException {
        context.verifyEntity(e);
        if (!context.isInRadius(e)) {
            throw new SpellRuntimeException("psi.spellerror.outsideradius");
        }
        Vec3d look = e.func_70040_Z();
        double offX = look.field_72450_a * dist;
        double offY = Math.max(0.0, look.field_72448_b * dist);
        double offZ = look.field_72449_c * dist;
        e.func_70634_a(e.func_226277_ct_() + offX, e.func_226278_cu_() + offY, e.func_226281_cx_() + offZ);
    }
}

