/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.spell.trick.block;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.api.spell.EnumSpellStat;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellMetadata;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.param.ParamVector;
import vazkii.psi.api.spell.piece.PieceTrick;
import vazkii.psi.common.spell.selector.entity.PieceSelectorNearbySmeltables;
import vazkii.psi.common.spell.trick.block.PieceTrickBreakBlock;

public class PieceTrickSmeltBlock
extends PieceTrick {
    SpellParam<Vector3> position;

    public PieceTrickSmeltBlock(Spell spell) {
        super(spell);
    }

    @Override
    public void initParams() {
        this.position = new ParamVector("psi.spellparam.position", SpellParam.BLUE, false, false);
        this.addParam(this.position);
    }

    @Override
    public void addToMetadata(SpellMetadata meta) throws SpellCompilationException {
        super.addToMetadata(meta);
        meta.addStat(EnumSpellStat.POTENCY, 20);
        meta.addStat(EnumSpellStat.COST, 80);
    }

    @Override
    public Object execute(SpellContext context) throws SpellRuntimeException {
        Item item;
        Block block1;
        Vector3 positionVal = this.getParamValue(context, this.position);
        ItemStack tool = context.tool;
        if (tool.func_190926_b()) {
            tool = PsiAPI.getPlayerCAD(context.caster);
        }
        if (positionVal == null) {
            throw new SpellRuntimeException("psi.spellerror.nullvector");
        }
        if (!context.isInRadius(positionVal)) {
            throw new SpellRuntimeException("psi.spellerror.outsideradius");
        }
        BlockPos pos = positionVal.toBlockPos();
        if (!context.caster.func_130014_f_().func_175660_a(context.caster, pos)) {
            return null;
        }
        BlockState state = context.caster.func_130014_f_().func_180495_p(pos);
        Block block = state.func_177230_c();
        ItemStack stack = new ItemStack((IItemProvider)block);
        BlockEvent.BreakEvent event = PieceTrickBreakBlock.createBreakEvent(state, context.caster, context.caster.field_70170_p, pos, tool);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            return null;
        }
        ItemStack result = PieceSelectorNearbySmeltables.simulateSmelt(context.caster.func_130014_f_(), stack);
        if (!result.func_190926_b() && (block1 = Block.func_149634_a((Item)(item = result.func_77973_b()))) != Blocks.field_150350_a) {
            context.caster.func_130014_f_().func_175656_a(pos, block1.func_176223_P());
            context.caster.func_130014_f_().func_217379_c(2001, pos, Block.func_196246_j((BlockState)block1.func_176223_P()));
        }
        return null;
    }
}

