/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.spell.other;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.List;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.model.Material;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.spell.EnumPieceType;
import vazkii.psi.api.spell.IRedirector;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellPiece;
import vazkii.psi.api.spell.param.ParamAny;

public class PieceConnector
extends SpellPiece
implements IRedirector {
    public static final ResourceLocation LINES_TEXTURE = new ResourceLocation("psi:spell/connector_lines");
    public SpellParam<SpellParam.Any> target;

    public PieceConnector(Spell spell) {
        super(spell);
    }

    @Override
    public String getSortingName() {
        return "00000000000";
    }

    @Override
    public ITextComponent getEvaluationTypeString() {
        return new TranslationTextComponent("psi.datatype.any", new Object[0]);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawAdditional(MatrixStack ms, IRenderTypeBuffer buffers, int light) {
        this.drawSide(ms, buffers, light, (SpellParam.Side)((Object)this.paramSides.get(this.target)));
        if (this.isInGrid) {
            block0: for (SpellParam.Side side : (SpellParam.Side[])SpellParam.Side.class.getEnumConstants()) {
                SpellPiece piece;
                if (!side.isEnabled() || (piece = this.spell.grid.getPieceAtSideSafely(this.x, this.y, side)) == null) continue;
                for (SpellParam<?> param : piece.paramSides.keySet()) {
                    SpellParam.Side paramSide = piece.paramSides.get(param);
                    if (paramSide.getOpposite() != side) continue;
                    this.drawSide(ms, buffers, light, side);
                    continue block0;
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void drawSide(MatrixStack ms, IRenderTypeBuffer buffers, int light, SpellParam.Side side) {
        if (side.isEnabled()) {
            Material material = new Material(PsiAPI.PSI_PIECE_TEXTURE_ATLAS, LINES_TEXTURE);
            IVertexBuilder buffer = material.func_229311_a_(buffers, ignored -> SpellPiece.getLayer());
            float minU = 0.0f;
            float minV = 0.0f;
            switch (side) {
                case LEFT: {
                    minU = 0.5f;
                    break;
                }
                default: {
                    break;
                }
                case TOP: {
                    minV = 0.5f;
                    break;
                }
                case BOTTOM: {
                    minU = 0.5f;
                    minV = 0.5f;
                }
            }
            float maxU = minU + 0.5f;
            float maxV = minV + 0.5f;
            Matrix4f mat = ms.func_227866_c_().func_227870_a_();
            buffer.func_227888_a_(mat, 0.0f, 16.0f, 0.0f).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f);
            buffer.func_225583_a_(minU, maxV).func_227886_a_(light).func_181675_d();
            buffer.func_227888_a_(mat, 16.0f, 16.0f, 0.0f).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f);
            buffer.func_225583_a_(maxU, maxV).func_227886_a_(light).func_181675_d();
            buffer.func_227888_a_(mat, 16.0f, 0.0f, 0.0f).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f);
            buffer.func_225583_a_(maxU, minV).func_227886_a_(light).func_181675_d();
            buffer.func_227888_a_(mat, 0.0f, 0.0f, 0.0f).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f);
            buffer.func_225583_a_(minU, minV).func_227886_a_(light).func_181675_d();
        }
    }

    @Override
    public void getShownPieces(List<SpellPiece> pieces) {
        for (SpellParam.Side side : (SpellParam.Side[])SpellParam.Side.class.getEnumConstants()) {
            if (!side.isEnabled()) continue;
            PieceConnector piece = (PieceConnector)SpellPiece.create(PieceConnector.class, new Spell());
            piece.paramSides.put(piece.target, side);
            pieces.add(piece);
        }
    }

    @Override
    public void initParams() {
        this.target = new ParamAny("psi.spellparam.target", SpellParam.GRAY, false);
        this.addParam(this.target);
    }

    @Override
    public EnumPieceType getPieceType() {
        return EnumPieceType.CONNECTOR;
    }

    @Override
    public SpellParam.Side getRedirectionSide() {
        return (SpellParam.Side)((Object)this.paramSides.get(this.target));
    }

    @Override
    public Class<?> getEvaluationType() {
        return null;
    }

    @Override
    public Object evaluate() {
        return null;
    }

    @Override
    public Object execute(SpellContext context) {
        return null;
    }
}

