/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.spell.operator.entity;

import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.entity.Entity;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.param.ParamEntity;
import vazkii.psi.api.spell.param.ParamEntityListWrapper;
import vazkii.psi.api.spell.piece.PieceOperator;
import vazkii.psi.api.spell.wrapper.EntityListWrapper;

public class PieceOperatorListAdd
extends PieceOperator {
    SpellParam<Entity> target;
    SpellParam<EntityListWrapper> list;

    public PieceOperatorListAdd(Spell spell) {
        super(spell);
    }

    @Override
    public void initParams() {
        this.target = new ParamEntity("psi.spellparam.target", SpellParam.BLUE, false, false);
        this.addParam(this.target);
        this.list = new ParamEntityListWrapper("psi.spellparam.list", SpellParam.YELLOW, true, false);
        this.addParam(this.list);
    }

    @Override
    public Object execute(SpellContext context) throws SpellRuntimeException {
        Entity targetVal = this.getParamValue(context, this.target);
        EntityListWrapper listVal = this.getParamValue(context, this.list);
        if (targetVal == null) {
            throw new SpellRuntimeException("psi.spellerror.nulltarget");
        }
        ArrayList<Entity> list = new ArrayList<Entity>(listVal.unwrap());
        int index = Collections.binarySearch(list, targetVal, EntityListWrapper::compareEntities);
        if (index < 0) {
            list.add(~index, targetVal);
        }
        return new EntityListWrapper(list);
    }

    @Override
    public Class<?> getEvaluationType() {
        return EntityListWrapper.class;
    }
}

