/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.spell.operator.entity;

import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.api.spell.ISpellImmune;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.param.ParamNumber;
import vazkii.psi.api.spell.param.ParamVector;
import vazkii.psi.api.spell.piece.PieceOperator;

public class PieceOperatorEntityRaycast
extends PieceOperator {
    SpellParam<Vector3> origin;
    SpellParam<Vector3> ray;
    SpellParam<Number> max;

    public PieceOperatorEntityRaycast(Spell spell) {
        super(spell);
    }

    @Override
    public void initParams() {
        this.origin = new ParamVector("psi.spellparam.position", SpellParam.BLUE, false, false);
        this.addParam(this.origin);
        this.ray = new ParamVector("psi.spellparam.ray", SpellParam.GREEN, false, false);
        this.addParam(this.ray);
        this.max = new ParamNumber("psi.spellparam.max", SpellParam.PURPLE, true, false);
        this.addParam(this.max);
    }

    @Override
    public Object execute(SpellContext context) throws SpellRuntimeException {
        Vector3 originVal = this.getParamValue(context, this.origin);
        Vector3 rayVal = this.getParamValue(context, this.ray);
        double maxLen = ((Number)this.getParamValueOrDefault(context, this.max, 32.0)).doubleValue();
        if (originVal == null || rayVal == null) {
            throw new SpellRuntimeException("psi.spellerror.nullvector");
        }
        Entity entity = PieceOperatorEntityRaycast.rayTraceEntities(context.caster.field_70170_p, (Entity)context.caster, originVal.toVec3D(), rayVal.toVec3D(), pred -> !pred.func_175149_v() && pred.func_70089_S() && pred.func_70067_L() && !(pred instanceof ISpellImmune), maxLen);
        if (entity == null) {
            throw new SpellRuntimeException("psi.spellerror.nulltarget");
        }
        return entity;
    }

    public static Entity rayTraceEntities(World world, Entity caster, Vec3d positionVector, Vec3d lookVector, Predicate<Entity> predicate, double maxDistance) {
        double distance = maxDistance;
        Entity entity = null;
        Vec3d reachVector = positionVector.func_178787_e(lookVector.func_186678_a(maxDistance));
        AxisAlignedBB aabb = new AxisAlignedBB(positionVector.field_72450_a, positionVector.field_72448_b, positionVector.field_72449_c, reachVector.field_72450_a, reachVector.field_72448_b, reachVector.field_72449_c).func_72314_b(1.0, 1.0, 1.0);
        for (Entity entity1 : world.func_175674_a(caster, aabb, predicate)) {
            double distanceTo;
            float collisionBorderSize = entity1.func_70111_Y();
            AxisAlignedBB axisalignedbb = entity1.func_174813_aQ().func_186662_g((double)collisionBorderSize);
            Optional optional = axisalignedbb.func_216365_b(positionVector, reachVector);
            if (axisalignedbb.func_72318_a(positionVector)) {
                if (!(0.0 < distance) && distance != 0.0) continue;
                entity = entity1;
                distance = 0.0;
                continue;
            }
            if (!optional.isPresent() || !((distanceTo = positionVector.func_72438_d((Vec3d)optional.get())) < distance)) continue;
            entity = entity1;
            distance = distanceTo;
        }
        return entity;
    }

    @Override
    public Class<?> getEvaluationType() {
        return Entity.class;
    }
}

