/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.common.item.base.IHUDItem;

public class ItemVectorRuler
extends Item
implements IHUDItem {
    private static final String TAG_SRC_X = "srcX";
    private static final String TAG_SRC_Y = "srcY";
    private static final String TAG_SRC_Z = "srcZ";
    private static final String TAG_DST_X = "dstX";
    private static final String TAG_DST_Y = "dstY";
    private static final String TAG_DST_Z = "dstZ";

    public ItemVectorRuler(Item.Properties properties) {
        super(properties.func_200917_a(1));
    }

    public ActionResultType func_195939_a(ItemUseContext ctx) {
        int srcY;
        BlockPos pos = ctx.func_195995_a();
        ItemStack stack = ctx.func_195999_j().func_184586_b(ctx.func_221531_n());
        int n = srcY = stack.func_196082_o().func_74764_b(TAG_SRC_Y) ? stack.func_196082_o().func_74762_e(TAG_SRC_Y) : -1;
        if (srcY == -1 || ctx.func_195999_j().func_225608_bj_()) {
            stack.func_196082_o().func_74768_a(TAG_SRC_X, pos.func_177958_n());
            stack.func_196082_o().func_74768_a(TAG_SRC_Y, pos.func_177956_o());
            stack.func_196082_o().func_74768_a(TAG_SRC_Z, pos.func_177952_p());
            stack.func_196082_o().func_74768_a(TAG_DST_Y, -1);
        } else {
            stack.func_196082_o().func_74768_a(TAG_DST_X, pos.func_177958_n());
            stack.func_196082_o().func_74768_a(TAG_DST_Y, pos.func_177956_o());
            stack.func_196082_o().func_74768_a(TAG_DST_Z, pos.func_177952_p());
        }
        return ActionResultType.SUCCESS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag advanced) {
        tooltip.add((ITextComponent)new StringTextComponent(this.getVector(stack).toString()));
    }

    public Vector3 getVector(ItemStack stack) {
        int dstY;
        int srcX = stack.func_196082_o().func_74762_e(TAG_SRC_X);
        int srcY = stack.func_196082_o().func_74762_e(TAG_SRC_Y);
        int srcZ = stack.func_196082_o().func_74762_e(TAG_SRC_Z);
        int n = dstY = stack.func_196082_o().func_74764_b(TAG_DST_Y) ? stack.func_196082_o().func_74762_e(TAG_DST_Y) : -1;
        if (dstY == -1) {
            return new Vector3(srcX, srcY, srcZ);
        }
        int dstX = stack.func_196082_o().func_74762_e(TAG_DST_X);
        int dstZ = stack.func_196082_o().func_74762_e(TAG_DST_Z);
        return new Vector3(dstX - srcX, dstY - srcY, dstZ - srcZ);
    }

    public static Vector3 getRulerVector(PlayerEntity player) {
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemVectorRuler)) continue;
            return ((ItemVectorRuler)stack.func_77973_b()).getVector(stack);
        }
        return Vector3.zero;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawHUD(MainWindow res, float partTicks, ItemStack stack) {
        String s = this.getVector(stack).toString();
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        int w = font.func_78256_a(s);
        font.func_175063_a(s, (float)res.func_198107_o() / 2.0f - (float)w / 2.0f, (float)res.func_198087_p() / 2.0f + 10.0f, -1);
    }
}

