/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.crafting.recipe;

import javax.annotation.Nonnull;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.item.crafting.SpecialRecipeSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import vazkii.psi.api.exosuit.IExosuitSensor;
import vazkii.psi.api.exosuit.ISensorHoldable;

public class SensorAttachRecipe
extends SpecialRecipe {
    public static final SpecialRecipeSerializer<SensorAttachRecipe> SERIALIZER = new SpecialRecipeSerializer(SensorAttachRecipe::new);

    public SensorAttachRecipe(ResourceLocation id) {
        super(id);
    }

    public boolean matches(@Nonnull CraftingInventory inv, @Nonnull World world) {
        boolean foundSensor = false;
        boolean foundTarget = false;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            if (stack.func_77973_b() instanceof ISensorHoldable && ((ISensorHoldable)stack.func_77973_b()).getAttachedSensor(stack).func_190926_b()) {
                if (foundTarget) {
                    return false;
                }
                foundTarget = true;
                continue;
            }
            if (stack.func_77973_b() instanceof IExosuitSensor) {
                if (foundSensor) {
                    return false;
                }
                foundSensor = true;
                continue;
            }
            return false;
        }
        return foundSensor && foundTarget;
    }

    @Nonnull
    public ItemStack getCraftingResult(@Nonnull CraftingInventory inv) {
        ItemStack sensor = ItemStack.field_190927_a;
        ItemStack target = ItemStack.field_190927_a;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            if (stack.func_77973_b() instanceof IExosuitSensor) {
                sensor = stack;
                continue;
            }
            target = stack;
        }
        ItemStack copy = target.func_77946_l();
        ISensorHoldable holdable = (ISensorHoldable)copy.func_77973_b();
        holdable.attachSensor(copy, sensor);
        return copy;
    }

    @Nonnull
    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }
}

