/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.core.handler;

import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class ConfigHandler {
    public static final Client CLIENT;
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final Common COMMON;
    public static final ForgeConfigSpec COMMON_SPEC;

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Client::new);
        CLIENT_SPEC = (ForgeConfigSpec)specPair.getRight();
        CLIENT = (Client)specPair.getLeft();
        specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Common {
        public final ForgeConfigSpec.BooleanValue magiPsiClientSide;
        public final ForgeConfigSpec.IntValue spellCacheSize;
        public final ForgeConfigSpec.IntValue cadHarvestLevel;

        public Common(ForgeConfigSpec.Builder builder) {
            this.magiPsiClientSide = builder.comment("Set this to true to disable all server side features from Magical Psi, to allow you to use it purely as a client side mod").define("common.magiPsiClientSide", false);
            this.spellCacheSize = builder.comment("How many compiled spells should be kept in a cache. Probably best not to mess with it if you don't know what you're doing.").defineInRange("common.spellCacheSize", 200, 0, Integer.MAX_VALUE);
            this.cadHarvestLevel = builder.comment("The harvest level of a CAD for the purposes of block breaking spells. Defaults to 3 (diamond level)").defineInRange("common.cadHarvestLevel", 3, 0, 255);
        }
    }

    public static class Client {
        public final ForgeConfigSpec.BooleanValue useShaders;
        public final ForgeConfigSpec.BooleanValue psiBarOnRight;
        public final ForgeConfigSpec.BooleanValue contextSensitiveBar;
        public final ForgeConfigSpec.IntValue maxPsiBarScale;

        public Client(ForgeConfigSpec.Builder builder) {
            this.useShaders = builder.comment("Controls whether Psi's shaders are used. If you're using the GLSL Shaders mod and are having graphical troubles with Psi stuff, you may want to turn this off.").define("client.useShaders", true);
            this.psiBarOnRight = builder.comment("Controls whether the Psi Bar should be rendered on the right of the screen or not.").define("client.psiBarOnRight", true);
            this.contextSensitiveBar = builder.comment("Controls whether the Psi Bar should be hidden if it's full and the player is holding an item that uses Psi.").define("client.contextSensitiveBar", true);
            this.maxPsiBarScale = builder.comment("The maximum scale your Psi bar can be. This prevents it from being too large on a bigger GUI scale. This is maximum amount of \\\"on screen pixels\\\" each actual pixel can take.").defineInRange("client.maxPsiBarScale", 3, 1, 5);
        }
    }
}

