/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.client.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.IRenderable;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.spell.EnumPieceType;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellPiece;
import vazkii.psi.api.spell.programmer.ProgrammerPopulateEvent;
import vazkii.psi.client.gui.GuiProgrammer;
import vazkii.psi.client.gui.button.GuiButtonPage;
import vazkii.psi.client.gui.button.GuiButtonSpellPiece;
import vazkii.psi.common.core.handler.PlayerDataHandler;
import vazkii.psi.common.spell.constant.PieceConstantNumber;

public class PiecePanelWidget
extends Widget
implements IRenderable,
IGuiEventListener {
    public final GuiProgrammer parent;
    public boolean panelEnabled = false;
    public final List<Button> panelButtons = new ArrayList<Button>();
    public int panelCursor;
    public TextFieldWidget searchField;
    public int page = 0;
    private static final int PIECES_PER_PAGE = 25;
    public final List<GuiButtonSpellPiece> visibleButtons = new ArrayList<GuiButtonSpellPiece>();

    public PiecePanelWidget(int x, int y, int width, int height, String message, GuiProgrammer programmer) {
        super(x, y, width, height, message);
        this.parent = programmer;
    }

    public void renderButton(int mouseX, int mouseY, float pTicks) {
        if (this.panelEnabled) {
            this.parent.getMinecraft().func_110434_K().func_110577_a(GuiProgrammer.texture);
            PiecePanelWidget.fill((int)this.x, (int)this.y, (int)(this.x + this.width), (int)(this.y + this.height), (int)-2013265920);
            if (this.visibleButtons.size() > 0) {
                Button button = this.visibleButtons.get(Math.max(0, Math.min(this.panelCursor, this.visibleButtons.size() - 1)));
                int panelPieceX = button.x;
                int panelPieceY = button.y;
                PiecePanelWidget.fill((int)(panelPieceX - 1), (int)(panelPieceY - 1), (int)(panelPieceX + 17), (int)(panelPieceY + 17), (int)0x559999FF);
            }
            RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
            this.blit(this.searchField.x - 14, this.searchField.y - 2, 0, this.parent.ySize + 16, 12, 12);
            String s = Math.min(Math.max(this.getPageCount(), 1), this.page + 1) + "/" + Math.max(this.getPageCount(), 1);
            this.parent.getMinecraft().field_71466_p.func_175063_a(s, (float)this.x + (float)this.width / 2.0f - (float)this.parent.getMinecraft().field_71466_p.func_78256_a(s) / 2.0f, (float)(this.y + this.height - 12), 0xFFFFFF);
        }
    }

    public boolean mouseScrolled(double par1, double par2, double par3) {
        int next;
        if (this.panelEnabled && par3 != 0.0 && (next = (int)((double)this.page - par3 / Math.abs(par3))) >= 0 && next < this.getPageCount()) {
            this.page = next;
            this.updatePanelButtons();
        }
        return false;
    }

    public boolean charTyped(char p_charTyped_1_, int p_charTyped_2_) {
        if (this.panelEnabled) {
            return this.searchField.charTyped(p_charTyped_1_, p_charTyped_2_);
        }
        return false;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.panelEnabled) {
            switch (keyCode) {
                case 256: {
                    this.closePanel();
                    return true;
                }
                case 257: {
                    if (this.visibleButtons.size() >= 1) {
                        this.visibleButtons.get(this.panelCursor).onPress();
                        return true;
                    }
                    return false;
                }
                case 258: {
                    if (this.visibleButtons.size() < 1) break;
                    int newCursor = this.panelCursor + (Screen.hasAltDown() ? -1 : 1);
                    if (newCursor >= Math.min(this.visibleButtons.size(), 25)) {
                        this.panelCursor = 0;
                        return true;
                    }
                    this.panelCursor = Math.max(0, Math.min(newCursor, Math.min(this.visibleButtons.size(), 25) - 1));
                    return true;
                }
            }
            this.searchField.keyPressed(keyCode, scanCode, modifiers);
        }
        return false;
    }

    public int getPageCount() {
        return this.visibleButtons.size() / 25 + 1;
    }

    public void populatePanelButtons() {
        PlayerDataHandler.PlayerData playerData = PlayerDataHandler.get((PlayerEntity)this.parent.getMinecraft().field_71439_g);
        ProgrammerPopulateEvent event = new ProgrammerPopulateEvent((PlayerEntity)this.parent.getMinecraft().field_71439_g, PsiAPI.getSpellPieceRegistry());
        ArrayList<SpellPiece> shownPieces = new ArrayList<SpellPiece>();
        MinecraftForge.EVENT_BUS.post((Event)event);
        for (ResourceLocation key : event.getSpellPieceRegistry().func_148742_b()) {
            Class clazz = (Class)event.getSpellPieceRegistry().func_218349_b(key).get();
            ResourceLocation group = PsiAPI.getGroupForPiece(clazz);
            if (!this.parent.getMinecraft().field_71439_g.func_184812_l_() && (group == null || !playerData.isPieceGroupUnlocked(group, key))) continue;
            SpellPiece piece = SpellPiece.create(clazz, this.parent.spell);
            shownPieces.clear();
            piece.getShownPieces(shownPieces);
            for (SpellPiece shownPiece : shownPieces) {
                GuiButtonSpellPiece spellPieceButton = new GuiButtonSpellPiece(this.parent, shownPiece, 0, 0, button -> {
                    if (this.parent.isSpectator()) {
                        return;
                    }
                    this.parent.pushState(true);
                    SpellPiece piece1 = ((GuiButtonSpellPiece)button).piece.copyFromSpell(this.parent.spell);
                    if (piece1.getPieceType() == EnumPieceType.TRICK && this.parent.spellNameField.func_146179_b().isEmpty()) {
                        String pieceName = I18n.func_135052_a((String)piece1.getUnlocalizedName(), (Object[])new Object[0]);
                        String patternStr = I18n.func_135052_a((String)"psimisc.trick_pattern", (Object[])new Object[0]);
                        Pattern pattern = Pattern.compile(patternStr);
                        Matcher matcher = pattern.matcher(pieceName);
                        if (matcher.matches()) {
                            String spellName = matcher.group(1);
                            this.parent.spellNameField.func_146180_a(spellName);
                            this.parent.spell.name = spellName;
                            this.parent.onSpellChanged(true);
                        }
                    }
                    this.parent.spell.grid.gridData[GuiProgrammer.selectedX][GuiProgrammer.selectedY] = piece1;
                    this.parent.spell.grid.gridData[GuiProgrammer.selectedX][GuiProgrammer.selectedY].isInGrid = true;
                    this.parent.spell.grid.gridData[GuiProgrammer.selectedX][GuiProgrammer.selectedY].x = GuiProgrammer.selectedX;
                    this.parent.spell.grid.gridData[GuiProgrammer.selectedX][GuiProgrammer.selectedY].y = GuiProgrammer.selectedY;
                    this.parent.onSpellChanged(false);
                    this.closePanel();
                });
                spellPieceButton.visible = false;
                spellPieceButton.active = false;
                this.panelButtons.add(spellPieceButton);
                this.visibleButtons.add(spellPieceButton);
            }
        }
        GuiButtonPage right = new GuiButtonPage(0, 0, true, this.parent, button -> {
            int max = this.getPageCount();
            int next = this.page + (((GuiButtonPage)button).right ? 1 : -1);
            if (next >= 0 && next < max) {
                this.page = next;
                this.updatePanelButtons();
            }
        });
        GuiButtonPage left = new GuiButtonPage(0, 0, false, this.parent, button -> {
            int max = this.getPageCount();
            int next = this.page + (((GuiButtonPage)button).right ? 1 : -1);
            if (next >= 0 && next < max) {
                this.page = next;
                this.updatePanelButtons();
            }
        });
        left.visible = false;
        left.active = false;
        right.visible = false;
        right.active = false;
        this.panelButtons.add(left);
        this.panelButtons.add(right);
        this.parent.addButtons(this.panelButtons);
    }

    public void updatePanelButtons() {
        int start;
        int c;
        Comparator<GuiButtonSpellPiece> comparator;
        this.panelCursor = 0;
        this.visibleButtons.clear();
        this.parent.getButtons().forEach(button -> {
            if (button instanceof GuiButtonPage || button instanceof GuiButtonSpellPiece) {
                button.active = false;
                button.visible = false;
            }
        });
        HashMap pieceRankings = new HashMap();
        String text = this.searchField.func_146179_b().toLowerCase().trim();
        boolean noSearchTerms = text.isEmpty();
        this.parent.getButtons().forEach(button -> {
            if (button instanceof GuiButtonSpellPiece) {
                SpellPiece piece = ((GuiButtonSpellPiece)((Object)button)).getPiece();
                if (noSearchTerms) {
                    this.visibleButtons.add((GuiButtonSpellPiece)((Object)button));
                } else {
                    int rank = this.ranking(text, piece);
                    if (rank > 0) {
                        pieceRankings.put(piece.getClass(), rank);
                        this.visibleButtons.add((GuiButtonSpellPiece)((Object)button));
                    }
                }
            } else if (button instanceof GuiButtonPage) {
                GuiButtonPage page = (GuiButtonPage)((Object)button);
                if (page.isRight() && this.page < this.getPageCount() - 1) {
                    button.x = this.x + this.width - 22;
                    button.y = this.y + this.height - 15;
                    button.visible = true;
                    button.active = true;
                } else if (!page.isRight() && this.page > 0) {
                    button.x = this.x + 4;
                    button.y = this.y + this.height - 15;
                    button.visible = true;
                    button.active = true;
                }
            }
        });
        if (noSearchTerms) {
            comparator = Comparator.comparing(GuiButtonSpellPiece::getPieceSortingName);
        } else {
            comparator = Comparator.comparingInt(p -> -((Integer)pieceRankings.get(p.getPiece().getClass())).intValue());
            comparator = comparator.thenComparing(GuiButtonSpellPiece::getPieceSortingName);
        }
        this.visibleButtons.sort(comparator);
        if (!text.isEmpty() && text.length() <= 5 && (text.matches("^-?\\d+(?:\\.\\d*)?") || text.matches("^-?\\d*(?:\\.\\d+)?"))) {
            GuiButtonSpellPiece constantPiece = this.parent.getButtons().stream().filter(el -> {
                if (el instanceof GuiButtonSpellPiece) {
                    return ((GuiButtonSpellPiece)((Object)el)).getPiece() instanceof PieceConstantNumber;
                }
                return false;
            }).findFirst().orElse(null);
            this.visibleButtons.remove((Object)constantPiece);
            ((PieceConstantNumber)constantPiece.getPiece()).valueStr = text;
            this.visibleButtons.add(0, constantPiece);
        }
        for (int i = start = this.page * 25; i < this.visibleButtons.size() && (c = i - start) < 25; ++i) {
            GuiButtonSpellPiece piece = this.visibleButtons.get(i);
            GuiButtonSpellPiece buttonSpellPiece = this.parent.getButtons().stream().filter(el -> el.equals((Object)piece)).findFirst().orElse(null);
            buttonSpellPiece.x = this.x + 5 + c % 5 * 18;
            buttonSpellPiece.y = this.y + 20 + c / 5 * 18;
            buttonSpellPiece.visible = true;
            buttonSpellPiece.active = true;
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (!(this.parent.cursorX == -1 || this.parent.cursorY == -1 || this.parent.commentEnabled || this.parent.isSpectator() || mouseButton != 1 || this.panelEnabled)) {
            this.openPanel();
            return true;
        }
        if (this.panelEnabled && (mouseX < (double)this.x || mouseY < (double)this.y || mouseX > (double)(this.x + this.width) || mouseY > (double)(this.y + this.height)) && !this.parent.isSpectator()) {
            this.closePanel();
            return true;
        }
        return false;
    }

    private int ranking(String token, SpellPiece p) {
        int rank = 0;
        String name = I18n.func_135052_a((String)p.getUnlocalizedName(), (Object[])new Object[0]).toLowerCase();
        String desc = I18n.func_135052_a((String)p.getUnlocalizedDesc(), (Object[])new Object[0]).toLowerCase();
        for (String nameToken : token.split("\\s+")) {
            if (nameToken.isEmpty()) continue;
            if (nameToken.startsWith("in:")) {
                String clippedToken = nameToken.substring(3);
                if (clippedToken.isEmpty()) continue;
                int maxRank = 0;
                for (SpellParam<?> param : p.params.values()) {
                    String type = param.getRequiredTypeString().func_150254_d().toLowerCase();
                    maxRank = Math.max(maxRank, this.rankTextToken(type, clippedToken));
                }
                if (maxRank <= 0) {
                    return 0;
                }
                rank += maxRank;
                continue;
            }
            if (nameToken.startsWith("out:")) {
                String clippedToken = nameToken.substring(4);
                if (clippedToken.isEmpty()) continue;
                String type = p.getEvaluationTypeString().func_150254_d().toLowerCase();
                if (this.rankTextToken(type, clippedToken) <= 0) {
                    return 0;
                }
                rank += this.rankTextToken(type, clippedToken);
                continue;
            }
            if (nameToken.startsWith("@")) {
                String clippedToken = nameToken.substring(1);
                if (clippedToken.isEmpty()) continue;
                String mod = PsiAPI.getSpellPieceKey(p.getClass()).func_110624_b();
                if (mod != null) {
                    int modRank = this.rankTextToken(mod, clippedToken);
                    if (modRank <= 0) {
                        return 0;
                    }
                    rank += modRank;
                    continue;
                }
                return 0;
            }
            int nameRank = this.rankTextToken(name, nameToken);
            rank += nameRank;
            if (nameRank <= 0 && this.rankTextToken(desc, nameToken) <= 0) {
                return 0;
            }
            rank += this.rankTextToken(desc, nameToken) / 2;
        }
        return rank;
    }

    private int rankTextToken(String haystack, String token) {
        if (token.isEmpty()) {
            return 0;
        }
        if (token.startsWith("_")) {
            String clippedToken = token.substring(1);
            if (clippedToken.isEmpty()) {
                return 0;
            }
            if (haystack.endsWith(clippedToken)) {
                if (!Character.isLetterOrDigit(haystack.charAt(haystack.length() - clippedToken.length() - 1))) {
                    return clippedToken.length() * 3 / 2;
                }
                return clippedToken.length();
            }
        } else if (token.endsWith("_")) {
            String clippedToken = token.substring(0, token.length() - 1);
            if (clippedToken.isEmpty()) {
                return 0;
            }
            if (haystack.startsWith(clippedToken)) {
                if (haystack.length() >= clippedToken.length() + 1 && !Character.isLetterOrDigit(haystack.charAt(clippedToken.length() + 1))) {
                    return clippedToken.length() * 2;
                }
                return clippedToken.length();
            }
        } else {
            int idx;
            if (token.startsWith("has:")) {
                token = token.substring(4);
            }
            if ((idx = haystack.indexOf(token)) >= 0) {
                int multiplier = 2;
                if (idx == 0 || !Character.isLetterOrDigit(haystack.charAt(idx - 1))) {
                    multiplier += 2;
                }
                if (idx + token.length() + 1 >= haystack.length() || !Character.isLetterOrDigit(haystack.charAt(idx + token.length() + 1))) {
                    ++multiplier;
                }
                return token.length() * multiplier / 2;
            }
        }
        return 0;
    }

    public void closePanel() {
        this.panelEnabled = false;
        this.parent.getButtons().forEach(button -> {
            if (button instanceof GuiButtonSpellPiece || button instanceof GuiButtonPage) {
                button.visible = false;
                button.active = false;
            }
        });
        this.searchField.visible = false;
        this.searchField.func_146184_c(false);
        this.searchField.func_146195_b(false);
        this.parent.setFocused((IGuiEventListener)this.parent.statusWidget);
        this.parent.changeFocus(true);
    }

    public void openPanel() {
        this.closePanel();
        this.panelEnabled = true;
        this.page = Math.min(this.page, Math.max(0, this.getPageCount() - 1));
        this.x = this.parent.gridLeft + (GuiProgrammer.selectedX + 1) * 18;
        this.y = this.parent.gridTop;
        this.searchField.x = this.x + 18;
        this.searchField.y = this.y + 4;
        this.searchField.func_146180_a("");
        this.searchField.func_146189_e(true);
        this.searchField.active = true;
        this.searchField.func_146184_c(true);
        this.searchField.func_146195_b(true);
        this.parent.setFocused((IGuiEventListener)this.searchField);
        this.updatePanelButtons();
    }
}

