/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.client.gui.button;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import vazkii.psi.api.internal.PsiRenderHelper;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellPiece;
import vazkii.psi.client.gui.GuiProgrammer;

public class GuiButtonSideConfig
extends Button {
    final GuiProgrammer gui;
    final int gridX;
    final int gridY;
    public final String paramName;
    final int paramIndex;
    final SpellParam.Side side;

    public GuiButtonSideConfig(GuiProgrammer gui, int gridX, int gridY, int paramIndex, String paramName, SpellParam.Side side, int x, int y) {
        super(x, y, 8, 8, "", Button::onPress);
        this.gui = gui;
        this.gridX = gridX;
        this.gridY = gridY;
        this.paramIndex = paramIndex;
        this.paramName = paramName;
        this.side = side;
    }

    public GuiButtonSideConfig(GuiProgrammer gui, int gridX, int gridY, int paramIndex, String paramName, SpellParam.Side side, int x, int y, Button.IPressable pressable) {
        super(x, y, 8, 8, "", pressable);
        this.gui = gui;
        this.gridX = gridX;
        this.gridY = gridY;
        this.paramIndex = paramIndex;
        this.paramName = paramName;
        this.side = side;
    }

    public void renderButton(int par2, int par3, float pTicks) {
        if (this.active && this.visible && !this.gui.takingScreenshot) {
            int minX = this.x;
            int minY = this.y;
            int maxX = minX + 8;
            int maxY = minY + 8;
            Minecraft.func_71410_x().field_71446_o.func_110577_a(GuiProgrammer.texture);
            SpellPiece piece = this.gui.spell.grid.gridData[this.gridX][this.gridY];
            if (piece == null) {
                return;
            }
            SpellParam<?> param = piece.params.get(this.paramName);
            if (param == null) {
                return;
            }
            SpellParam.Side currSide = piece.paramSides.get(param);
            if (currSide == this.side) {
                RenderSystem.color4f((float)((float)PsiRenderHelper.r(param.color) / 255.0f), (float)((float)PsiRenderHelper.g(param.color) / 255.0f), (float)((float)PsiRenderHelper.b(param.color) / 255.0f), (float)1.0f);
            } else {
                RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
            }
            float wh = 8.0f;
            float minU = (float)this.side.u / 256.0f;
            float minV = (float)this.side.v / 256.0f;
            float maxU = ((float)this.side.u + wh) / 256.0f;
            float maxV = ((float)this.side.v + wh) / 256.0f;
            RenderSystem.enableAlphaTest();
            BufferBuilder wr = Tessellator.func_178181_a().func_178180_c();
            wr.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            wr.func_225582_a_((double)minX, (double)maxY, 0.0).func_225583_a_(minU, maxV).func_181675_d();
            wr.func_225582_a_((double)maxX, (double)maxY, 0.0).func_225583_a_(maxU, maxV).func_181675_d();
            wr.func_225582_a_((double)maxX, (double)minY, 0.0).func_225583_a_(maxU, minV).func_181675_d();
            wr.func_225582_a_((double)minX, (double)minY, 0.0).func_225583_a_(minU, minV).func_181675_d();
            Tessellator.func_178181_a().func_78381_a();
            RenderSystem.disableAlphaTest();
        }
    }

    public boolean matches(int index, SpellParam.Side side) {
        return this.paramIndex == index && this.side == side;
    }

    public static void performAction(GuiProgrammer gui, int gridX, int gridY, String paramName, SpellParam.Side side) {
        SpellPiece piece = gui.spell.grid.gridData[gridX][gridY];
        if (piece == null) {
            return;
        }
        SpellParam<?> param = piece.params.get(paramName);
        if (param == null) {
            return;
        }
        piece.paramSides.put(param, side);
    }
}

