/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.api.spell.detonator;

import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.spell.detonator.DetonationEvent;

public interface IDetonationHandler {
    public static IDetonationHandler detonator(Entity entity) {
        return (IDetonationHandler)entity.getCapability(PsiAPI.DETONATION_HANDLER_CAPABILITY).orElseThrow(NullPointerException::new);
    }

    public static void performDetonation(World world, PlayerEntity player) {
        IDetonationHandler.performDetonation(world, player, (Entity)player, 32.0, e -> true);
    }

    public static void performDetonation(World world, PlayerEntity player, double range) {
        IDetonationHandler.performDetonation(world, player, (Entity)player, range, e -> true);
    }

    public static void performDetonation(World world, PlayerEntity player, Predicate<Entity> filter) {
        IDetonationHandler.performDetonation(world, player, (Entity)player, 32.0, filter);
    }

    public static void performDetonation(World world, PlayerEntity player, double range, Predicate<Entity> filter) {
        IDetonationHandler.performDetonation(world, player, (Entity)player, range, filter);
    }

    public static void performDetonation(World world, PlayerEntity player, Entity center) {
        IDetonationHandler.performDetonation(world, player, center, 32.0, e -> true);
    }

    public static void performDetonation(World world, PlayerEntity player, Entity center, double range) {
        IDetonationHandler.performDetonation(world, player, center, range, e -> true);
    }

    public static void performDetonation(World world, PlayerEntity player, Entity center, Predicate<Entity> filter) {
        IDetonationHandler.performDetonation(world, player, center, 32.0, filter);
    }

    public static void performDetonation(World world, PlayerEntity player, Entity center, double range, Predicate<Entity> filter) {
        List charges = world.func_175647_a(Entity.class, center.func_174813_aQ().func_186662_g(range), entity -> {
            if (entity == null) {
                return false;
            }
            return (Boolean)entity.getCapability(PsiAPI.DETONATION_HANDLER_CAPABILITY).map(detonator -> {
                Vec3d locus = detonator.objectLocus();
                if (locus == null || locus.func_186679_c(center.func_226277_ct_(), center.func_226278_cu_(), center.func_226281_cx_()) > range * range) {
                    return false;
                }
                return filter == null || filter.test((Entity)entity);
            }).orElse((Object)false);
        });
        List<IDetonationHandler> handlers = charges.stream().map(e -> (IDetonationHandler)e.getCapability(PsiAPI.DETONATION_HANDLER_CAPABILITY).orElseThrow(NullPointerException::new)).collect(Collectors.toList());
        if (!MinecraftForge.EVENT_BUS.post((Event)new DetonationEvent(player, center, range, handlers)) && !handlers.isEmpty()) {
            for (IDetonationHandler handler : handlers) {
                handler.detonate();
            }
        }
    }

    default public Vec3d objectLocus() {
        return null;
    }

    public void detonate();
}

