/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.tile.config;

import com.raoulvdberge.refinedstorage.tile.config.IRedstoneConfigurable;
import com.raoulvdberge.refinedstorage.tile.data.TileDataParameter;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public enum RedstoneMode {
    IGNORE,
    HIGH,
    LOW;

    private static final String NBT = "RedstoneMode";

    public boolean isEnabled(World world, BlockPos pos) {
        switch (this) {
            case IGNORE: {
                return true;
            }
            case HIGH: {
                return world.func_175640_z(pos);
            }
            case LOW: {
                return !world.func_175640_z(pos);
            }
        }
        return false;
    }

    public void write(CompoundNBT tag) {
        tag.func_74768_a(NBT, this.ordinal());
    }

    public static RedstoneMode read(CompoundNBT tag) {
        if (tag.func_74764_b(NBT)) {
            return RedstoneMode.getById(tag.func_74762_e(NBT));
        }
        return IGNORE;
    }

    public static RedstoneMode getById(int id) {
        return id < 0 || id >= RedstoneMode.values().length ? IGNORE : RedstoneMode.values()[id];
    }

    public static <T extends TileEntity> TileDataParameter<Integer, T> createParameter() {
        return new TileDataParameter<Integer, TileEntity>(DataSerializers.field_187192_b, IGNORE.ordinal(), t -> ((IRedstoneConfigurable)t).getRedstoneMode().ordinal(), (t, v) -> ((IRedstoneConfigurable)t).setRedstoneMode(RedstoneMode.getById(v)));
    }
}

